/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.instrument.classloading;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class JBossModulesLoadTimeWeaver
implements LoadTimeWeaver {
    private final ClassLoader classLoader;

    public JBossModulesLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public JBossModulesLoadTimeWeaver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        try {
            Field transformers = ReflectionUtils.findField(this.classLoader.getClass(), (String)"transformer");
            transformers.setAccessible(true);
            Object delegatingTransformer = transformers.get(this.classLoader);
            Method ADD_TRANSFORMER = ReflectionUtils.findMethod(delegatingTransformer.getClass(), (String)"addTransformer", (Class[])new Class[]{ClassFileTransformer.class});
            ADD_TRANSFORMER.setAccessible(true);
            ADD_TRANSFORMER.invoke(delegatingTransformer, transformer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.classLoader);
    }
}

