/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.agents.memory.SizingAgent;
import org.apache.ode.axis2.ExternalService;
import org.apache.ode.axis2.ODEServer;
import org.apache.ode.axis2.ODEService;
import org.apache.ode.axis2.SoapExternalService;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ode.axis2.hooks.ODEMessageReceiver;
import org.apache.ode.axis2.httpbinding.HttpExternalService;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.utils.wsdl.WsdlUtils;

public class BindingContextImpl
implements BindingContext {
    protected final Log __log = LogFactory.getLog(this.getClass());
    private ODEServer _server;
    private MultiKeyMap _services = new MultiKeyMap();
    private Map<ODEService, EndpointReference> _serviceEprMap = new HashMap<ODEService, EndpointReference>();

    public BindingContextImpl(ODEServer server) {
        this._server = server;
    }

    public EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
        try {
            ProcessConf pconf = this._server._store.getProcessConfiguration(processId);
            Definition wsdl = pconf.getDefinitionForService(myRoleEndpoint.serviceName);
            if (wsdl == null) {
                throw new ContextException("Unable to access WSDL definition to activate MyRole endpoint for service " + myRoleEndpoint.serviceName + " and port " + myRoleEndpoint.portName);
            }
            ODEService svc = this.createService(pconf, myRoleEndpoint.serviceName, myRoleEndpoint.portName);
            EndpointReference epr = svc.getMyServiceRef();
            this._serviceEprMap.put(svc, epr);
            return epr;
        }
        catch (AxisFault axisFault) {
            throw new ContextException("Could not activate endpoint for service " + myRoleEndpoint.serviceName + " and port " + myRoleEndpoint.portName, (Throwable)axisFault);
        }
    }

    public void deactivateMyRoleEndpoint(Endpoint myRoleEndpoint) {
        ODEService service = this.destroyService(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
        if (service != null) {
            this._serviceEprMap.remove(service);
        }
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType, Endpoint initialPartnerEndpoint) {
        ProcessConf pconf = this._server._store.getProcessConfiguration(processId);
        Definition wsdl = pconf.getDefinitionForService(initialPartnerEndpoint.serviceName);
        if (wsdl == null) {
            throw new ContextException("Cannot find definition for service " + initialPartnerEndpoint.serviceName + " in the context of process " + processId);
        }
        return this.createExternalService(pconf, initialPartnerEndpoint.serviceName, initialPartnerEndpoint.portName);
    }

    public long calculateSizeofService(EndpointReference epr) {
        if (this._server._odeConfig.isProcessSizeThrottled()) {
            for (ODEService service : this._serviceEprMap.keySet()) {
                if (!epr.equals(this._serviceEprMap.get(epr))) continue;
                return SizingAgent.deepSizeOf((Object)service);
            }
        }
        return 0L;
    }

    protected ODEService createService(ProcessConf pconf, QName serviceName, String portName) throws AxisFault {
        AxisService axisService = ODEAxisService.createService(this._server._axisConfig, pconf, serviceName, portName);
        ODEService odeService = new ODEService(axisService, pconf, serviceName, portName, (BpelServer)this._server._bpelServer, this._server._txMgr);
        this.destroyService(serviceName, portName);
        this._services.put((Object)serviceName, (Object)portName, (Object)odeService);
        Iterator operationIterator = axisService.getOperations();
        while (operationIterator.hasNext()) {
            AxisOperation op = (AxisOperation)operationIterator.next();
            if (!(op.getMessageReceiver() instanceof ODEMessageReceiver)) continue;
            ((ODEMessageReceiver)op.getMessageReceiver()).setService(odeService);
            break;
        }
        this._server._axisConfig.addService(axisService);
        this.__log.debug((Object)("Created Axis2 service " + serviceName));
        return odeService;
    }

    protected ODEService destroyService(QName serviceName, String portName) {
        this.__log.debug((Object)("Destroying service " + serviceName + " port " + portName));
        ODEService service = (ODEService)this._services.remove((Object)serviceName, (Object)portName);
        if (service != null) {
            try {
                String axisServiceName = service.getAxisService().getName();
                AxisService axisService = this._server._axisConfig.getService(axisServiceName);
                axisService.releaseSchemaList();
                ArrayList parameters = axisService.getParameters();
                for (Parameter parameter : parameters) {
                    axisService.removeParameter(parameter);
                }
                this._server._axisConfig.stopService(axisServiceName);
                this._server._axisConfig.removeService(service.getName());
                this.completeCleanup(axisService);
                this._server._axisConfig.cleanup();
            }
            catch (AxisFault axisFault) {
                this.__log.error((Object)("Couldn't destroy service " + serviceName));
            }
        } else {
            this.__log.debug((Object)("Couldn't find service " + serviceName + " port " + portName + " to destroy."));
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCleanup(AxisService service) {
        try {
            Field field = this._server._axisConfig.getClass().getDeclaredField("allEndpoints");
            field.setAccessible(true);
            AxisConfiguration axisConfiguration = this._server._axisConfig;
            synchronized (axisConfiguration) {
                Map allEndpoints = (Map)field.get(this._server._axisConfig);
                Iterator iter = service.getEndpoints().keySet().iterator();
                while (iter.hasNext()) {
                    allEndpoints.remove(service.getName() + "." + (String)iter.next());
                }
            }
        }
        catch (Exception e) {
            this.__log.error((Object)"Workaround for ODE-580/AXIS2-3870 failed. AxisConfig clean up might be incomplete.", (Throwable)e);
        }
    }

    protected ExternalService createExternalService(ProcessConf pconf, QName serviceName, String portName) throws ContextException {
        ExternalService extService = null;
        Definition def = pconf.getDefinitionForService(serviceName);
        try {
            if (WsdlUtils.useHTTPBinding((Definition)def, (QName)serviceName, (String)portName)) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Creating HTTP-bound external service " + serviceName));
                }
                extService = new HttpExternalService(pconf, serviceName, portName, this._server._executorService, this._server._scheduler, (BpelServer)this._server._bpelServer, this._server.httpConnectionManager);
            } else if (WsdlUtils.useSOAPBinding((Definition)def, (QName)serviceName, (String)portName)) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Creating SOAP-bound external service " + serviceName));
                }
                extService = new SoapExternalService(pconf, serviceName, portName, this._server._executorService, this._server._axisConfig, this._server._scheduler, (BpelServer)this._server._bpelServer, this._server.httpConnectionManager);
            }
        }
        catch (Exception ex) {
            this.__log.error((Object)"Could not create external service.", (Throwable)ex);
            throw new ContextException("Error creating external service! name:" + serviceName + ", port:" + portName, (Throwable)ex);
        }
        if (extService == null) {
            throw new ContextException("Only SOAP and HTTP binding supported!");
        }
        this.__log.debug((Object)("Created external service " + serviceName));
        return extService;
    }
}

