/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ODEAxisOperationDispatcher
extends AbstractDispatcher {
    private static MultiKeyMap _elmtToOperation = new MultiKeyMap();
    public static final String NAME = "ODEAxisOperationDispatcher";
    private static final Log log = LogFactory.getLog(ODEAxisOperationDispatcher.class);
    QName operationName = null;

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        OMElement bodyFirstChild;
        AxisOperation operation;
        String action = messageContext.getWSAAction();
        if (action != null) {
            log.debug((Object)Messages.getMessage((String)"checkingoperation", (String)action));
            operation = service.getOperationByAction(action);
            if (operation != null) {
                return operation;
            }
        }
        if ((bodyFirstChild = messageContext.getEnvelope().getBody().getFirstElement()) != null) {
            AxisOperation op;
            String localName = bodyFirstChild.getLocalName();
            log.debug((Object)("Checking for Operation using SOAP message body's first child's local name : " + localName));
            operation = service.getOperation(new QName(localName));
            if (operation != null) {
                log.debug((Object)("Found operation " + operation));
                return operation;
            }
            int index = localName.lastIndexOf("Request");
            if (index >= 0 && index + "Request".length() == localName.length() && (op = service.getOperation(new QName(localName.substring(0, index)))) != null) {
                return op;
            }
            index = localName.lastIndexOf("Response");
            if (index >= 0 && index + "Response".length() == localName.length() && (op = service.getOperation(new QName(localName.substring(0, index)))) != null) {
                return op;
            }
            String opName = (String)_elmtToOperation.get((Object)service.getName(), (Object)localName);
            if (opName != null) {
                operation = service.getOperation(new QName(opName));
                return operation;
            }
        }
        log.warn((Object)"No operation has been found!");
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public static void addElmtToOpMapping(String axisServiceName, String operationName, String elmtName) {
        if (operationName.equals(elmtName)) {
            return;
        }
        _elmtToOperation.put((Object)axisServiceName, (Object)elmtName, (Object)operationName);
    }
}

