/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.hooks;

import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ODEAxisServiceDispatcher
extends AbstractDispatcher {
    public static final String NAME = "ODEAxisServiceDispatcher";
    private static final Log log = LogFactory.getLog(ODEAxisServiceDispatcher.class);
    QName operationName = null;

    public AxisOperation findOperation(AxisService service, MessageContext messageContext) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            AxisConfiguration registry;
            AxisService service;
            log.debug((Object)("Checking for Service using target endpoint address : " + toEPR.getAddress()));
            String path = this.parseRequestURLForService(toEPR.getAddress());
            if (path != null && (service = (registry = messageContext.getConfigurationContext().getAxisConfiguration()).getService(path)) != null) {
                log.debug((Object)("Found service in registry from name " + path + ": " + service));
                return service;
            }
        }
        log.warn((Object)"No service has been found!");
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    protected String parseRequestURLForService(String path) {
        int index = path.indexOf("/processes/");
        if (-1 != index) {
            int serviceStart = index + "/processes/".length();
            if (path.length() > serviceStart + 1) {
                String service = path.substring(serviceStart);
                int queryIndex = service.indexOf(63);
                if (queryIndex > 0) {
                    service = service.substring(0, queryIndex);
                }
                return service;
            }
        }
        return null;
    }
}

