/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.ode.utils.CollectionUtils;

public class CorrelationKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _csetName;
    private String[] _keyValues;

    public CorrelationKey(String csetName, String[] keyValues) {
        this._csetName = csetName;
        this._keyValues = keyValues;
    }

    public CorrelationKey(String canonicalForm) {
        int firstTilde = canonicalForm.indexOf(126);
        this._csetName = canonicalForm.substring(0, firstTilde == -1 ? canonicalForm.length() : firstTilde);
        if (firstTilde != -1) {
            ArrayList<String> keys = new ArrayList<String>();
            char[] chars = canonicalForm.toCharArray();
            StringBuffer work = new StringBuffer();
            for (int i = firstTilde + 1; i < chars.length; ++i) {
                boolean isLast;
                boolean bl = isLast = i == chars.length - 1;
                if (chars[i] == '~' && !isLast && chars[i + 1] == '~') {
                    work.append(chars[i++]);
                    continue;
                }
                if (chars[i] == '~') {
                    keys.add(work.toString());
                    work = new StringBuffer();
                    continue;
                }
                work.append(chars[i]);
            }
            keys.add(work.toString());
            this._keyValues = new String[keys.size()];
            keys.toArray(this._keyValues);
        } else {
            this._keyValues = new String[0];
        }
    }

    public String getCorrelationSetName() {
        return this._csetName;
    }

    public String[] getValues() {
        return this._keyValues;
    }

    public boolean isMatch(CorrelationKey[] keys) {
        for (CorrelationKey key : keys) {
            if (!key.equals(this)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        CorrelationKey okey = (CorrelationKey)o;
        if (okey == null || !okey._csetName.equals(this._csetName) || okey._keyValues.length != this._keyValues.length) {
            return false;
        }
        for (int i = 0; i < this._keyValues.length; ++i) {
            if (this._keyValues[i].equals(okey._keyValues[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this._csetName.hashCode();
        for (String _keyValue : this._keyValues) {
            hashCode ^= _keyValue.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{CorrelationKey ");
        buf.append("setId=");
        buf.append(this._csetName);
        buf.append(", values=");
        buf.append(CollectionUtils.makeCollection(ArrayList.class, (Object[])this._keyValues));
        buf.append('}');
        return buf.toString();
    }

    public String toCanonicalString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._csetName);
        buf.append('~');
        for (int i = 0; i < this.getValues().length; ++i) {
            if (i != 0) {
                buf.append('~');
            }
            CorrelationKey.escapeTilde(buf, this.getValues()[i]);
        }
        return buf.toString();
    }

    static void escapeTilde(StringBuffer buf, String str) {
        char[] chars;
        if (str == null) {
            return;
        }
        for (char achar : chars = str.toCharArray()) {
            if (achar == '~') {
                buf.append("~~");
                continue;
            }
            buf.append(achar);
        }
    }
}

