/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.OptionalCorrelationKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationKeySet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    private String version = "2";
    private final Set<CorrelationKey> correlationKeys = new TreeSet<CorrelationKey>(new CorrelationKeyComparator());

    public CorrelationKeySet() {
    }

    public CorrelationKeySet(String canonicalForm) {
        this.restore(canonicalForm);
    }

    public CorrelationKeySet add(CorrelationKey ck) {
        for (CorrelationKey key : this.correlationKeys) {
            if (key.getCorrelationSetName() != ck.getCorrelationSetName()) continue;
            this.correlationKeys.remove(ck);
            break;
        }
        this.correlationKeys.add(ck);
        return this;
    }

    public boolean isOpaque() {
        return this.correlationKeys.size() == 1 && this.correlationKeys.iterator().next().getCorrelationSetName().equals("-1");
    }

    public boolean isRoutableTo(CorrelationKeySet candidateKeySet, boolean isAllRoute) {
        boolean isRoutable = this.containsAll(candidateKeySet);
        if (isAllRoute) {
            isRoutable = isRoutable || candidateKeySet.isOpaque() && this.isEmpty();
        }
        return isRoutable;
    }

    public boolean containsAll(CorrelationKeySet c) {
        Iterator<CorrelationKey> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.correlationKeys.isEmpty();
    }

    public boolean contains(CorrelationKey correlationKey) {
        Iterator<CorrelationKey> e = this.correlationKeys.iterator();
        if (correlationKey == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!correlationKey.equals(e.next())) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator<CorrelationKey> iterator() {
        return this.correlationKeys.iterator();
    }

    public void clear() {
        this.correlationKeys.clear();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CorrelationKeySet)) {
            return false;
        }
        CorrelationKeySet another = (CorrelationKeySet)o;
        if (this.correlationKeys.size() != another.correlationKeys.size()) {
            return false;
        }
        return this.containsAll(another);
    }

    public List<CorrelationKeySet> findSubSets() {
        ArrayList<CorrelationKeySet> subSets = new ArrayList<CorrelationKeySet>();
        CorrelationKey opaqueKey = null;
        boolean containsNonOpaque = false;
        CorrelationKeySet explicitKeySet = new CorrelationKeySet();
        for (CorrelationKey ckey : this.correlationKeys) {
            if (ckey.getCorrelationSetName().equals("-1")) {
                opaqueKey = ckey;
            } else {
                containsNonOpaque = true;
            }
            explicitKeySet.add(ckey);
        }
        if (opaqueKey != null && containsNonOpaque) {
            explicitKeySet.correlationKeys.remove(opaqueKey);
        }
        int setIndex = 0;
        while ((double)setIndex < Math.pow(2.0, explicitKeySet.correlationKeys.size())) {
            CorrelationKeySet subKeySet = new CorrelationKeySet();
            Iterator<CorrelationKey> ckeys = explicitKeySet.iterator();
            for (int bitPattern = setIndex; ckeys.hasNext() && bitPattern > 0; bitPattern >>= 1) {
                CorrelationKey ckey = ckeys.next();
                if ((bitPattern & 1) <= 0) continue;
                subKeySet.add(ckey);
            }
            if (!subKeySet.isEmpty()) {
                subSets.add(subKeySet);
            }
            ++setIndex;
        }
        if (subSets.isEmpty()) {
            subSets.add(new CorrelationKeySet());
        }
        return subSets;
    }

    public String toCanonicalString() {
        StringBuffer buf = new StringBuffer();
        for (CorrelationKey ckey : this.correlationKeys) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append("[").append(CorrelationKeySet.escapeRightBracket(ckey.toCanonicalString())).append("]");
        }
        return "@2" + buf.toString();
    }

    private static String escapeRightBracket(String str) {
        char[] chars;
        if (str == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (char achar : chars = str.toCharArray()) {
            if (achar == ']') {
                buf.append("]]");
                continue;
            }
            buf.append(achar);
        }
        return buf.toString();
    }

    public String toString() {
        return this.correlationKeys.toString();
    }

    public void restore(String canonicalForm) {
        if (canonicalForm == null || canonicalForm.trim().length() == 0) {
            return;
        }
        if (canonicalForm.startsWith("@")) {
            this.parseCanonicalForm(canonicalForm);
        } else {
            this.version = VERSION_1;
            this.add(new CorrelationKey(canonicalForm));
        }
    }

    private void parseCanonicalForm(String canonicalForm) {
        ParserState state = ParserState.INITIAL;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < canonicalForm.length(); ++i) {
            char ch = canonicalForm.charAt(i);
            if (state == ParserState.INITIAL) {
                if (ch == '@') {
                    state = ParserState.MET_ALPHA;
                    continue;
                }
                buf.append(ch);
                state = ParserState.MET_LEFT_BRACKET;
                continue;
            }
            if (state == ParserState.MET_ALPHA) {
                if (ch == '[') {
                    this.version = buf.toString();
                    buf.setLength(0);
                    state = ParserState.MET_LEFT_BRACKET;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (state == ParserState.MET_LEFT_BRACKET) {
                if (ch == ']') {
                    state = ParserState.MET_RIGHT_BRACKET;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (state == ParserState.MET_RIGHT_BRACKET) {
                if (ch == ']') {
                    buf.append(ch);
                    state = ParserState.MET_LEFT_BRACKET;
                    continue;
                }
                if (ch == ',') {
                    if (buf.toString().trim().length() != 0) {
                        this.add(new CorrelationKey(buf.toString()));
                    }
                    buf.setLength(0);
                    state = ParserState.MET_COMMA;
                    continue;
                }
                if (ch != '?') continue;
                if (buf.toString().trim().length() != 0) {
                    this.add(new OptionalCorrelationKey(buf.toString()));
                }
                buf.setLength(0);
                state = ParserState.MET_COMMA;
                continue;
            }
            if (state != ParserState.MET_COMMA || ch != '[') continue;
            state = ParserState.MET_LEFT_BRACKET;
        }
        if (buf.toString().trim().length() != 0) {
            if (state == ParserState.MET_ALPHA) {
                this.version = buf.toString();
            } else {
                this.add(new CorrelationKey(buf.toString()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CorrelationKeyComparator
    implements Serializable,
    Comparator<CorrelationKey> {
        private static final long serialVersionUID = 1L;

        private CorrelationKeyComparator() {
        }

        @Override
        public int compare(CorrelationKey o1, CorrelationKey o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.getCorrelationSetName().compareTo(o2.getCorrelationSetName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParserState {
        INITIAL,
        MET_ALPHA,
        MET_LEFT_BRACKET,
        MET_RIGHT_BRACKET,
        MET_COMMA;

    }
}

