/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.RelativeDateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceFilter
extends Filter<Criteria>
implements Serializable {
    protected static Log LOG = LogFactory.getLog(InstanceFilter.class);
    private static final long serialVersionUID = 9999L;
    private List<String> iids;
    private List<String> pids;
    private boolean arePidsNegative;
    private String nameFilter;
    private String namespaceFilter;
    private List<String> statusFilter;
    private List<String> startedDateFilter;
    private List<String> lastActiveDateFilter;
    private Map<String, String> propertyValuesFilter;
    public List<String> orders;
    private int limit;

    public InstanceFilter(String filter, String orderKeys, int limit) {
        this.init(filter);
        if (this.statusFilter != null) {
            for (String status : this.statusFilter) {
                try {
                    StatusKeys.valueOf(status.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRequestException("The status you're using in your filter isn't valid, only the active, suspended, error, completed, terminated and faulted status are valid. " + e.toString());
                }
            }
        }
        if (this.startedDateFilter != null) {
            for (String ddf : this.startedDateFilter) {
                try {
                    this.parseDateExpression(InstanceFilter.getDateWithoutOp(ddf));
                }
                catch (ParseException e) {
                    throw new InvalidRequestException("Couldn't parse one of the filter date, please make sure it follows the ISO-8601 date or date/time standard (yyyyMMddhhmmss). " + e.toString());
                }
            }
        }
        if (this.lastActiveDateFilter != null) {
            for (String ddf : this.lastActiveDateFilter) {
                try {
                    this.parseDateExpression(InstanceFilter.getDateWithoutOp(ddf));
                }
                catch (ParseException e) {
                    throw new InvalidRequestException("Couldn't parse one of the filter date, please make sure it follows the ISO-8601 date or date/time standard (yyyyMMddhhmmss). " + e.toString());
                }
            }
        }
        if (orderKeys != null && orderKeys.length() > 0) {
            this.orders = new ArrayList<String>(3);
            StringTokenizer orderKeysTok = new StringTokenizer(orderKeys, " ");
            while (orderKeysTok.hasMoreTokens()) {
                String orderKey = orderKeysTok.nextToken();
                try {
                    String justKey = orderKey;
                    if (justKey.startsWith("-") || justKey.startsWith("+")) {
                        justKey = orderKey.substring(1, justKey.length());
                    }
                    OrderKeys.valueOf(justKey.replaceAll("-", "_").toUpperCase());
                    this.orders.add(orderKey);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRequestException("One of the ordering keys isn't valid, processes can only be sorted by pid, name, namespace, version, status, started and last-active date." + e.toString());
                }
            }
        }
        if (limit < 0) {
            throw new IllegalArgumentException("Limit should be greater or equal to 0.");
        }
        this.limit = limit;
    }

    public InstanceFilter(String filter) {
        this(filter, null, Integer.MAX_VALUE);
    }

    private Date parseDateExpression(String date) throws ParseException {
        if (date.toLowerCase().startsWith("-") && date.length() > 1) {
            return RelativeDateParser.parseRelativeDate((String)date.substring(1));
        }
        return ISO8601DateParser.parse((String)date);
    }

    public List<Short> convertFilterState() {
        ArrayList<Short> result = new ArrayList<Short>(5);
        short noState = 200;
        for (String status : this.statusFilter) {
            if (StatusKeys.ACTIVE.toString().equalsIgnoreCase(status)) {
                result.add((short)0);
                result.add((short)20);
                result.add((short)10);
                continue;
            }
            if (StatusKeys.SUSPENDED.toString().equalsIgnoreCase(status)) {
                result.add((short)50);
                continue;
            }
            if (StatusKeys.ERROR.toString().equalsIgnoreCase(status)) {
                result.add(noState);
                continue;
            }
            if (StatusKeys.COMPLETED.toString().equalsIgnoreCase(status)) {
                result.add((short)30);
                continue;
            }
            if (StatusKeys.TERMINATED.toString().equalsIgnoreCase(status)) {
                result.add((short)60);
                continue;
            }
            if (StatusKeys.FAILED.toString().equalsIgnoreCase(status)) {
                result.add((short)40);
                continue;
            }
            result.add(noState);
        }
        return result;
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public String getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public List<String> getStatusFilter() {
        return this.statusFilter;
    }

    public List<String> getStartedDateFilter() {
        return this.startedDateFilter;
    }

    public List<String> getLastActiveDateFilter() {
        return this.lastActiveDateFilter;
    }

    public Map<String, String> getPropertyValuesFilter() {
        return this.propertyValuesFilter;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public List<String> getPidFilter() {
        return this.pids;
    }

    public boolean arePidsNegative() {
        return this.arePidsNegative;
    }

    public List<String> getIidFilter() {
        return this.iids;
    }

    public static void main(String[] args) {
        InstanceFilter instf = new InstanceFilter("name = dtc* namespace=http://www.intalio.com* status=active|terminated started>=2005-11-29T15:15:19 started<2005-11-29T15:15:20 last-active < 2005-11-30 ${http://ode.org/}order-id= 12 $shipping-id=aa45fz", "name started", 50);
        System.out.println(instf);
    }

    @Override
    protected Criteria parseKey(String keyVal) {
        if (keyVal.startsWith("$")) {
            return Criteria.PROPERTY;
        }
        return Criteria.valueOf(keyVal);
    }

    protected Criteria[] getFilterKeys() {
        return Criteria.values();
    }

    @Override
    protected void process(Criteria key, Filter.Restriction<String> rest) {
        key.process(this, rest.originalKey, rest.op, (String)rest.value);
    }

    public int getLimit() {
        return this.limit;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("InstanceFilter {");
        buf.append("iids=" + this.iids);
        if (!this.arePidsNegative) {
            buf.append(",pids=" + this.pids);
        } else {
            buf.append(",-pids=" + this.pids);
        }
        buf.append(",name=" + this.nameFilter);
        buf.append(",namespace=" + this.namespaceFilter);
        buf.append(",status=" + this.statusFilter);
        buf.append(",startedDate=" + this.startedDateFilter);
        buf.append(",lastActiveDate=" + this.lastActiveDateFilter);
        buf.append(",propertyValues=" + this.propertyValuesFilter);
        buf.append(",orders=" + this.orders);
        buf.append(",limit=" + this.limit);
        buf.append("}");
        return buf.toString();
    }

    private static List<String> parse(String pipeDelimited) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(pipeDelimited, "|");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StatusKeys {
        ACTIVE,
        SUSPENDED,
        ERROR,
        COMPLETED,
        TERMINATED,
        FAILED,
        FAULTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OrderKeys {
        PID,
        NAME,
        NAMESPACE,
        VERSION,
        STATUS,
        STARTED,
        LAST_ACTIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Criteria {
        IID{

            void process(InstanceFilter filter, String key, String op, String value) {
                filter.iids = InstanceFilter.parse(value);
            }
        }
        ,
        PID{

            void process(InstanceFilter filter, String key, String op, String value) {
                filter.pids = InstanceFilter.parse(value);
                filter.arePidsNegative = "<>".equals(op);
            }
        }
        ,
        NAME{

            void process(InstanceFilter filter, String key, String op, String value) {
                filter.nameFilter = value;
            }
        }
        ,
        NAMESPACE{

            void process(InstanceFilter filter, String key, String op, String value) {
                filter.namespaceFilter = value;
            }
        }
        ,
        STATUS{

            void process(InstanceFilter filter, String key, String op, String value) {
                filter.statusFilter = InstanceFilter.parse(value);
            }
        }
        ,
        STARTED{

            void process(InstanceFilter filter, String key, String op, String value) {
                if (filter.startedDateFilter == null) {
                    filter.startedDateFilter = new ArrayList();
                }
                filter.startedDateFilter.add(op + value);
            }
        }
        ,
        LAST_ACTIVE{

            void process(InstanceFilter filter, String key, String op, String value) {
                if (filter.lastActiveDateFilter == null) {
                    filter.lastActiveDateFilter = new ArrayList();
                }
                filter.lastActiveDateFilter.add(op + value);
            }
        }
        ,
        PROPERTY{

            void process(InstanceFilter filter, String key, String op, String value) {
                if (filter.propertyValuesFilter == null) {
                    filter.propertyValuesFilter = new HashMap(5);
                }
                filter.propertyValuesFilter.put(key.substring(1, key.length()), value);
            }
        };


        abstract void process(InstanceFilter var1, String var2, String var3, String var4);
    }
}

