/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.utils.ISO8601DateParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessFilter
extends Filter<FilterKeysOp>
implements Serializable {
    private static final long serialVersionUID = 9999L;
    private String nameFilter;
    private String namespaceFilter;
    private String statusFilter;
    private List<String> deployedDateFilter;
    private List<String> includes;
    private List<String> orders;

    public ProcessFilter(String filter, String orderKeys) {
        this.init(filter);
        if (this.statusFilter != null) {
            try {
                StatusKeys.valueOf(this.statusFilter.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRequestException("The status you're using in your filter isn't valid, only the activated and retired status are valid. " + e.toString());
            }
        }
        if (this.deployedDateFilter != null) {
            for (String ddf : this.deployedDateFilter) {
                try {
                    ISO8601DateParser.parse((String)ProcessFilter.getDateWithoutOp(ddf));
                }
                catch (ParseException e) {
                    throw new InvalidRequestException("Couldn't parse one of the filter date, please make sure it follows the ISO-8601 date or date/time standard (yyyyMMddhhmmss). " + e.toString());
                }
            }
        }
        if (orderKeys != null && orderKeys.length() > 0) {
            this.orders = new ArrayList<String>(3);
            StringTokenizer orderKeysTok = new StringTokenizer(orderKeys, " ");
            while (orderKeysTok.hasMoreTokens()) {
                String orderKey = orderKeysTok.nextToken();
                try {
                    String justKey = orderKey;
                    if (justKey.startsWith("-") || justKey.startsWith("+")) {
                        justKey = orderKey.substring(1, justKey.length());
                    }
                    OrderKeys.valueOf(justKey.toUpperCase());
                    this.orders.add(orderKey);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidRequestException("One of the ordering keys isn't valid, processes can only be sorted by name, namespace, version, status and deployed date." + e.toString());
                }
            }
        }
    }

    public String getNameFilter() {
        return this.nameFilter;
    }

    public String getNamespaceFilter() {
        return this.namespaceFilter;
    }

    public String getStatusFilter() {
        return this.statusFilter;
    }

    public List<String> getDeployedDateFilter() {
        return this.deployedDateFilter;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public static void main(String[] args) {
        ProcessFilter pf = new ProcessFilter("name = dtc* status=activated deployed>=2005-11-29T15:12 deployed < 2005-11-29T15:13", "status name -version");
        System.out.println("=> " + pf);
    }

    @Override
    protected FilterKeysOp parseKey(String keyVal) {
        return FilterKeysOp.valueOf(keyVal);
    }

    protected FilterKeysOp[] getFilterKeys() {
        return FilterKeysOp.values();
    }

    @Override
    protected void process(FilterKeysOp key, Filter.Restriction<String> rest) {
        key.process(this, rest.op, (String)rest.value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StatusKeys {
        ACTIVATED,
        RETIRED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OrderKeys {
        NAME,
        NAMESPACE,
        VERSION,
        STATUS,
        DEPLOYED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FilterKeysOp {
        NAME{

            void process(ProcessFilter filter, String op, String value) {
                filter.nameFilter = value;
            }
        }
        ,
        NAMESPACE{

            void process(ProcessFilter filter, String op, String value) {
                filter.namespaceFilter = value;
            }
        }
        ,
        STATUS{

            void process(ProcessFilter filter, String op, String value) {
                filter.statusFilter = value;
            }
        }
        ,
        DEPLOYED{

            void process(ProcessFilter filter, String op, String value) {
                if (filter.deployedDateFilter == null) {
                    filter.deployedDateFilter = new ArrayList();
                }
                filter.deployedDateFilter.add(op + value);
            }
        };


        abstract void process(ProcessFilter var1, String var2, String var3);
    }
}

