/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.dbutil;

import java.io.File;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTrackingCoordinator;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.il.dbutil.Messages;
import org.apache.ode.utils.LoggingInterceptor;
import org.tranql.connector.jdbc.JDBCDriverMCF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private static final Log __log = LogFactory.getLog(Database.class);
    private static final Log __logSql = LogFactory.getLog((String)"org.apache.ode.sql");
    private static final Messages __msgs = (Messages)Messages.getMessages(Messages.class);
    private static final int CONNECTION_MAX_WAIT_MILLIS = 30000;
    private static final int CONNECTION_MAX_IDLE_MINUTES = 5;
    private OdeConfigProperties _odeConfig;
    private boolean _started;
    private GenericConnectionManager _connectionManager;
    private TransactionManager _txm;
    private DataSource _datasource;
    private File _workRoot;
    private boolean _needDerbyShutdown;
    private String _derbyUrl;

    public Database(OdeConfigProperties props) {
        if (props == null) {
            throw new NullPointerException("Must provide a configuration.");
        }
        this._odeConfig = props;
    }

    public void setWorkRoot(File workRoot) {
        this._workRoot = workRoot;
    }

    public void setTransactionManager(TransactionManager txm) {
        this._txm = txm;
    }

    public synchronized void start() throws DatabaseConfigException {
        if (this._started) {
            return;
        }
        this._needDerbyShutdown = false;
        this._datasource = null;
        this._connectionManager = null;
        this.initDataSource();
        this._started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (!this._started) {
            return;
        }
        if (this._connectionManager != null) {
            try {
                __log.debug((Object)"Stopping connection manager");
                this._connectionManager.doStop();
            }
            catch (Throwable t) {
                __log.warn((Object)("Exception while stopping connection manager: " + t.getMessage()));
            }
            finally {
                this._connectionManager = null;
            }
        }
        if (this._needDerbyShutdown) {
            __log.debug((Object)"shutting down derby.");
            EmbeddedDriver driver = new EmbeddedDriver();
            try {
                driver.connect(this._derbyUrl + ";shutdown=true", new Properties());
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() != 45000) {
                    __log.error((Object)("Error shutting down Derby: " + ex.getErrorCode()), (Throwable)ex);
                }
            }
            catch (Throwable ex) {
                __log.debug((Object)"Error shutting down Derby.", ex);
            }
        }
        this._needDerbyShutdown = false;
        this._datasource = null;
        this._started = false;
    }

    public DataSource getDataSource() {
        return __logSql.isDebugEnabled() ? LoggingInterceptor.createLoggingDS((DataSource)this._datasource, (Log)__logSql) : this._datasource;
    }

    private void initDataSource() throws DatabaseConfigException {
        switch (this._odeConfig.getDbMode()) {
            case EXTERNAL: {
                this.initExternalDb();
                break;
            }
            case EMBEDDED: {
                this.initEmbeddedDb();
                break;
            }
            case INTERNAL: {
                this.initInternalDb();
                break;
            }
        }
    }

    private void initExternalDb() throws DatabaseConfigException {
        try {
            this._datasource = (DataSource)this.lookupInJndi(this._odeConfig.getDbDataSource());
            __log.info((Object)__msgs.msgOdeUsingExternalDb(this._odeConfig.getDbDataSource()));
        }
        catch (Exception ex) {
            String msg = __msgs.msgOdeInitExternalDbFailed(this._odeConfig.getDbDataSource());
            __log.error((Object)msg, (Throwable)ex);
            throw new DatabaseConfigException(msg, ex);
        }
    }

    private void initInternalDb() throws DatabaseConfigException {
        __log.info(__msgs.msgOdeUsingInternalDb(this._odeConfig.getDbIntenralJdbcUrl(), this._odeConfig.getDbInternalJdbcDriverClass()));
        this.initInternalDb(this._odeConfig.getDbIntenralJdbcUrl(), this._odeConfig.getDbInternalJdbcDriverClass(), this._odeConfig.getDbInternalUserName(), this._odeConfig.getDbInternalPassword());
    }

    private void initInternalDb(String url, String driverClass, String username, String password) throws DatabaseConfigException {
        __log.debug((Object)("Creating connection pool for " + url + " with driver " + driverClass));
        if (!(this._txm instanceof RecoverableTransactionManager)) {
            throw new RuntimeException("TransactionManager is not recoverable.");
        }
        TransactionSupport transactionSupport = LocalTransactions.INSTANCE;
        ConnectionTrackingCoordinator connectionTracker = new ConnectionTrackingCoordinator();
        SinglePool poolingSupport = new SinglePool(this._odeConfig.getPoolMaxSize(), this._odeConfig.getPoolMinSize(), 30000, 5, true, false, false);
        this._connectionManager = new GenericConnectionManager(transactionSupport, (PoolingSupport)poolingSupport, null, (ConnectionTracker)connectionTracker, (RecoverableTransactionManager)this._txm, this.getClass().getName(), this.getClass().getClassLoader());
        try {
            JDBCDriverMCF mcf = null;
            String mcfClass = this._odeConfig.getDbInternalMCFClass();
            if (mcfClass != null) {
                Properties dbInternalMCFProps = this._odeConfig.getDbInternalMCFProperties();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Using internal DB MCF " + mcfClass + " " + dbInternalMCFProps));
                }
                mcf = (ManagedConnectionFactory)Class.forName(mcfClass).newInstance();
                BeanUtils.copyProperties((Object)mcf, (Object)dbInternalMCFProps);
            } else {
                JDBCDriverMCF mcf2;
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)"Using internal DB JDBCDriverMCF");
                }
                mcf = mcf2 = new JDBCDriverMCF();
                mcf2.setDriver(driverClass);
                mcf2.setConnectionURL(url);
                if (username != null) {
                    mcf2.setUserName(username);
                }
                if (password != null) {
                    mcf2.setPassword(password);
                }
            }
            this._connectionManager.doStart();
            this._datasource = (DataSource)mcf.createConnectionFactory((ConnectionManager)this._connectionManager);
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgOdeDbPoolStartupFailed(url);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DatabaseConfigException(errmsg, ex);
        }
    }

    private void initEmbeddedDb() throws DatabaseConfigException {
        String db = this._odeConfig.getDbEmbeddedName();
        String url = "jdbc:derby:" + this._workRoot + "/" + db;
        __log.info((Object)("Using Embedded Derby: " + url));
        this._derbyUrl = url;
        this.initInternalDb(url, EmbeddedDriver.class.getName(), "sa", null);
        this._needDerbyShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T lookupInJndi(String objName) throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Object object;
            block11: {
                InitialContext ctx = null;
                try {
                    ctx = new InitialContext();
                    object = ctx.lookup(objName);
                    if (ctx == null) break block11;
                }
                catch (Throwable throwable) {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Exception ex1) {
                            __log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                        }
                    }
                    throw throwable;
                }
                try {
                    ctx.close();
                }
                catch (Exception ex1) {
                    __log.error((Object)"Error closing JNDI connection.", (Throwable)ex1);
                }
            }
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public BpelDAOConnectionFactoryJDBC createDaoCF() throws DatabaseConfigException {
        BpelDAOConnectionFactoryJDBC cf;
        String pClassName = this._odeConfig.getDAOConnectionFactory();
        __log.info((Object)__msgs.msgOdeUsingDAOImpl(pClassName));
        try {
            cf = (BpelDAOConnectionFactoryJDBC)Class.forName(pClassName).newInstance();
        }
        catch (Exception ex) {
            String errmsg = __msgs.msgDAOInstantiationFailed(pClassName);
            __log.error((Object)errmsg, (Throwable)ex);
            throw new DatabaseConfigException(errmsg, ex);
        }
        cf.setDataSource(this.getDataSource());
        cf.setTransactionManager((Object)this._txm);
        cf.init(this._odeConfig.getProperties());
        return cf;
    }
}

