/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.ql.jcc;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ode.ql.jcc.ASTAnd;
import org.apache.ode.ql.jcc.ASTEqual;
import org.apache.ode.ql.jcc.ASTField;
import org.apache.ode.ql.jcc.ASTGE;
import org.apache.ode.ql.jcc.ASTGreater;
import org.apache.ode.ql.jcc.ASTIn;
import org.apache.ode.ql.jcc.ASTInValues;
import org.apache.ode.ql.jcc.ASTLE;
import org.apache.ode.ql.jcc.ASTLess;
import org.apache.ode.ql.jcc.ASTLike;
import org.apache.ode.ql.jcc.ASTLimit;
import org.apache.ode.ql.jcc.ASTOr;
import org.apache.ode.ql.jcc.ASTOrderBy;
import org.apache.ode.ql.jcc.ASTOrderByField;
import org.apache.ode.ql.jcc.ASTOrderType;
import org.apache.ode.ql.jcc.ASTProperty;
import org.apache.ode.ql.jcc.ASTStart;
import org.apache.ode.ql.jcc.ASTValue;
import org.apache.ode.ql.jcc.Node;
import org.apache.ode.ql.jcc.ParseException;
import org.apache.ode.ql.jcc.Parser;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.nodes.Conjunction;
import org.apache.ode.ql.tree.nodes.Disjunction;
import org.apache.ode.ql.tree.nodes.Equality;
import org.apache.ode.ql.tree.nodes.Field;
import org.apache.ode.ql.tree.nodes.GE;
import org.apache.ode.ql.tree.nodes.Greater;
import org.apache.ode.ql.tree.nodes.Identifier;
import org.apache.ode.ql.tree.nodes.In;
import org.apache.ode.ql.tree.nodes.LE;
import org.apache.ode.ql.tree.nodes.Less;
import org.apache.ode.ql.tree.nodes.Like;
import org.apache.ode.ql.tree.nodes.Limit;
import org.apache.ode.ql.tree.nodes.LogicNode;
import org.apache.ode.ql.tree.nodes.OrderBy;
import org.apache.ode.ql.tree.nodes.OrderByElement;
import org.apache.ode.ql.tree.nodes.OrderByType;
import org.apache.ode.ql.tree.nodes.Property;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.ql.tree.nodes.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBuilder
extends Builder<String> {
    @Override
    public org.apache.ode.ql.tree.nodes.Node build(String query) {
        try {
            ASTStart start = new Parser(query).start();
            return this.build(start);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    private org.apache.ode.ql.tree.nodes.Node build(Node node) {
        if (node instanceof ASTAnd) {
            return this.createConjunction(node);
        }
        if (node instanceof ASTOr) {
            return this.createDisjunction(node);
        }
        if (node instanceof ASTLess) {
            return this.createLess(node);
        }
        if (node instanceof ASTGreater) {
            return this.createGreater(node);
        }
        if (node instanceof ASTLE) {
            return this.createLE(node);
        }
        if (node instanceof ASTIn) {
            return this.createIn(node);
        }
        if (node instanceof ASTGE) {
            return this.createGE(node);
        }
        if (node instanceof ASTEqual) {
            return this.createEquality(node);
        }
        if (node instanceof ASTLike) {
            return this.createLike(node);
        }
        if (node instanceof ASTStart) {
            return this.createSelection((ASTStart)node);
        }
        throw new IllegalArgumentException("Unsupported node type " + node.getClass());
    }

    private Query createSelection(ASTStart node) {
        ArrayList<Object> childs = new ArrayList<Object>(node.jjtGetNumChildren());
        OrderBy orderBy = null;
        Limit limit = null;
        for (int index = 0; index < node.jjtGetNumChildren(); ++index) {
            Node childNode = node.jjtGetChild(index);
            if (childNode instanceof ASTOrderBy) {
                orderBy = this.createOrderBy(childNode);
                continue;
            }
            if (childNode instanceof ASTLimit) {
                limit = this.createLimit(childNode);
                continue;
            }
            org.apache.ode.ql.tree.nodes.Node child = this.build(childNode);
            childs.add(child);
        }
        return new Query(childs, orderBy, limit);
    }

    private OrderBy createOrderBy(Node node) {
        ArrayList<OrderByElement> orders = new ArrayList<OrderByElement>(node.jjtGetNumChildren());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            orders.add(this.createOrderByElement((ASTOrderByField)node.jjtGetChild(i)));
        }
        return new OrderBy(orders);
    }

    private OrderByElement createOrderByElement(ASTOrderByField node) {
        int childsNum = node.jjtGetNumChildren();
        if (childsNum == 1) {
            OrderByType orderByType = OrderByType.ASC;
        }
        if (childsNum != 2) {
            throw new IllegalArgumentException();
        }
        ASTOrderType astType = (ASTOrderType)this.extractChildNode(node, 1);
        OrderByType type = OrderByType.valueOf(astType.getValue().toUpperCase());
        Identifier id = this.createIdentifier(node, 0);
        return new OrderByElement<Identifier>(id, type);
    }

    private Conjunction createConjunction(Node node) {
        Collection<LogicNode> childs = this.extractLogicNodes(node);
        return new Conjunction(childs);
    }

    private Disjunction createDisjunction(Node node) {
        Collection<LogicNode> childs = this.extractLogicNodes(node);
        return new Disjunction(childs);
    }

    private LE createLE(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new LE(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private In createIn(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        Node inValuesNode = this.extractChildNode(node, 1, ASTInValues.class);
        ArrayList<Value> values = new ArrayList<Value>(inValuesNode.jjtGetNumChildren());
        for (int index = 0; index < inValuesNode.jjtGetNumChildren(); ++index) {
            values.add(this.createValue(inValuesNode, index));
        }
        return new In(this.createIdentifier(node, 0), values);
    }

    private GE createGE(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new GE(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Less createLess(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Less(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Greater createGreater(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Greater(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Equality createEquality(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Equality(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Like createLike(Node node) {
        TreeBuilder.checkChildsNumber(node, 2);
        return new Like(this.createIdentifier(node, 0), this.createValue(node, 1));
    }

    private Value createValue(Node parentNode, int index) {
        return new Value<String>(this.extractValue((Node)parentNode, (int)index).value);
    }

    private Limit createLimit(Node node) {
        return new Limit(((ASTLimit)node).getNumber());
    }

    private Identifier createIdentifier(Node parentNode, int index) {
        Node node = this.extractChildNode(parentNode, index);
        if (node instanceof ASTField) {
            return new Field(((ASTField)node).name);
        }
        if (node instanceof ASTProperty) {
            return new Property(((ASTProperty)node).getName());
        }
        throw new IllegalArgumentException("");
    }

    private ASTValue extractValue(Node parentNode, int index) {
        return (ASTValue)this.extractChildNode(parentNode, index, ASTValue.class);
    }

    private Node extractChildNode(Node parentNode, int index, Class expected) {
        Node node = this.extractChildNode(parentNode, index);
        if (!expected.isAssignableFrom(node.getClass())) {
            throw new IllegalArgumentException("");
        }
        return node;
    }

    private Node extractChildNode(Node parentNode, int index) {
        if (parentNode.jjtGetNumChildren() <= index) {
            throw new IllegalArgumentException("");
        }
        return parentNode.jjtGetChild(index);
    }

    private Collection<LogicNode> extractLogicNodes(Node parentNode) {
        ArrayList<LogicNode> childs = new ArrayList<LogicNode>(parentNode.jjtGetNumChildren());
        for (int index = 0; index < parentNode.jjtGetNumChildren(); ++index) {
            childs.add((LogicNode)this.build(parentNode.jjtGetChild(index)));
        }
        return childs;
    }

    private static void checkChildsNumber(Node node, int expected) {
        int actual = node.jjtGetNumChildren();
        if (actual != expected) {
            throw new IllegalArgumentException("Expected childs cound(" + actual + ") differes from expected " + expected);
        }
    }
}

