/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.dao.jpa.BPELDAOConnectionImpl;
import org.apache.ode.dao.jpa.JpaTxMgrProvider;

public class BPELDAOConnectionFactoryImpl
implements BpelDAOConnectionFactoryJDBC {
    static final Log __log = LogFactory.getLog(BPELDAOConnectionFactoryImpl.class);
    protected EntityManagerFactory _emf;
    private TransactionManager _tm;
    private DataSource _ds;
    private Object _dbdictionary;
    static ThreadLocal<BPELDAOConnectionImpl> _connections = new ThreadLocal();

    public BpelDAOConnection getConnection() {
        try {
            this._tm.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int i) {
                    if (_connections.get() != null) {
                        _connections.get().getEntityManager().close();
                    }
                    _connections.set(null);
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (RollbackException e) {
            throw new RuntimeException("Coulnd't register synchronizer!");
        }
        catch (SystemException e) {
            throw new RuntimeException("Coulnd't register synchronizer!");
        }
        if (_connections.get() != null) {
            return _connections.get();
        }
        HashMap<String, String> propMap2 = new HashMap<String, String>();
        propMap2.put("openjpa.TransactionMode", "managed");
        EntityManager em = this._emf.createEntityManager(propMap2);
        BPELDAOConnectionImpl conn = this.createBPELDAOConnection(em);
        _connections.set(conn);
        return conn;
    }

    protected BPELDAOConnectionImpl createBPELDAOConnection(EntityManager em) {
        return new BPELDAOConnectionImpl(em);
    }

    public void init(Properties properties) {
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("openjpa.Log", "commons");
        propMap.put("openjpa.ManagedRuntime", new JpaTxMgrProvider(this._tm));
        propMap.put("openjpa.ConnectionFactory", this._ds);
        propMap.put("openjpa.ConnectionFactoryMode", "managed");
        propMap.put("openjpa.FetchBatchSize", 1000);
        propMap.put("openjpa.jdbc.TransactionIsolation", "read-committed");
        if (this._dbdictionary != null) {
            propMap.put("openjpa.jdbc.DBDictionary", this._dbdictionary);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> me : properties.entrySet()) {
                propMap.put((String)me.getKey(), me.getValue());
            }
        }
        this._emf = Persistence.createEntityManagerFactory((String)"ode-dao", propMap);
    }

    public void setTransactionManager(TransactionManager tm) {
        this._tm = tm;
    }

    public void setDataSource(DataSource datasource) {
        this._ds = datasource;
    }

    public void setDBDictionary(String dbd) {
        this._dbdictionary = dbd;
    }

    public void setTransactionManager(Object tm) {
        this._tm = (TransactionManager)tm;
    }

    public void setUnmanagedDataSource(DataSource ds) {
    }

    public void shutdown() {
        this._emf.close();
    }

    public DataSource getDataSource() {
        return this._ds;
    }
}

