/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.CorrelatorMessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.MessageRouteDAOImpl;
import org.apache.ode.dao.jpa.OpenJPADAO;
import org.apache.ode.dao.jpa.ProcessDAOImpl;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ODE_CORRELATOR")
@NamedQueries(value={@NamedQuery(name="DELETE_CORRELATORS_BY_PROCESS", query="delete from CorrelatorDAOImpl as c where c._process = :process")})
public class CorrelatorDAOImpl
extends OpenJPADAO
implements CorrelatorDAO,
PersistenceCapable {
    private static Log __log = LogFactory.getLog(CorrelatorDAOImpl.class);
    public static final String DELETE_CORRELATORS_BY_PROCESS = "DELETE_CORRELATORS_BY_PROCESS";
    private static final String ROUTE_BY_CKEY_HEADER = "select route from MessageRouteDAOImpl as route where route._correlator._process._processType = :ptype and route._correlator._correlatorKey = :corrkey";
    @Id
    @Column(name="CORRELATOR_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _correlatorId;
    @Basic
    @Column(name="CORRELATOR_KEY")
    private String _correlatorKey;
    @OneToMany(targetEntity=MessageRouteDAOImpl.class, mappedBy="_correlator", fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<MessageRouteDAOImpl> _routes = new ArrayList<MessageRouteDAOImpl>();
    @OneToMany(targetEntity=MessageExchangeDAOImpl.class, mappedBy="_correlator", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<MessageExchangeDAOImpl> _exchanges = new ArrayList<MessageExchangeDAOImpl>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Column(name="PROC_ID")
    private ProcessDAOImpl _process;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$Collection;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl;
    static /* synthetic */ Class class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl;
    private transient Object pcDetachedState;

    public CorrelatorDAOImpl() {
    }

    public CorrelatorDAOImpl(String correlatorKey, ProcessDAOImpl process) {
        this._correlatorKey = correlatorKey;
        this._process = process;
    }

    public void addRoute(String routeGroupId, ProcessInstanceDAO target, int index, CorrelationKeySet correlationKeySet, String routePolicy) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("addRoute " + routeGroupId + " " + target + " " + index + " " + correlationKeySet + " " + routePolicy));
        }
        MessageRouteDAOImpl mr = new MessageRouteDAOImpl(correlationKeySet, routeGroupId, index, (ProcessInstanceDAOImpl)target, this, routePolicy);
        CorrelatorDAOImpl.pcGet_routes(this).add(mr);
        this.getEM().flush();
    }

    public MessageExchangeDAO dequeueMessage(CorrelationKeySet correlationKeySet) {
        Iterator itr = CorrelatorDAOImpl.pcGet_exchanges(this).iterator();
        while (itr.hasNext()) {
            MessageExchangeDAOImpl mex = (MessageExchangeDAOImpl)itr.next();
            if (!mex.getCorrelationKeySet().isRoutableTo(correlationKeySet, false)) continue;
            itr.remove();
            return mex;
        }
        return null;
    }

    public void enqueueMessage(MessageExchangeDAO mex, CorrelationKeySet correlationKeySet) {
        MessageExchangeDAOImpl mexImpl = (MessageExchangeDAOImpl)mex;
        mexImpl.setCorrelationKeySet(correlationKeySet);
        CorrelatorDAOImpl.pcGet_exchanges(this).add(mexImpl);
        mexImpl.setCorrelator(this);
    }

    public Collection<CorrelatorMessageDAO> getAllMessages() {
        return new ArrayList<CorrelatorMessageDAO>(CorrelatorDAOImpl.pcGet_exchanges(this));
    }

    public List<MessageRouteDAO> findRoute(CorrelationKeySet correlationKeySet) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("findRoute " + correlationKeySet));
        }
        List subSets = correlationKeySet.findSubSets();
        Query qry = this.getEM().createQuery(this.generateSelectorQuery(ROUTE_BY_CKEY_HEADER, subSets));
        qry.setParameter("ptype", (Object)CorrelatorDAOImpl.pcGet_process(this).getType().toString());
        qry.setParameter("corrkey", (Object)CorrelatorDAOImpl.pcGet_correlatorKey(this));
        for (int i = 0; i < subSets.size(); ++i) {
            qry.setParameter("s" + i, (Object)((CorrelationKeySet)subSets.get(i)).toCanonicalString());
        }
        List candidateRoutes = qry.getResultList();
        if (candidateRoutes.size() > 0) {
            ArrayList<MessageRouteDAO> matchingRoutes = new ArrayList<MessageRouteDAO>();
            boolean routed = false;
            for (int i = 0; i < candidateRoutes.size(); ++i) {
                MessageRouteDAO route = (MessageRouteDAO)candidateRoutes.get(i);
                if ("all".equals(route.getRoute())) {
                    matchingRoutes.add(route);
                    continue;
                }
                if (!routed) {
                    matchingRoutes.add(route);
                }
                routed = true;
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("findRoute found " + matchingRoutes));
            }
            return matchingRoutes;
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"findRoute found nothing");
        }
        return null;
    }

    private String generateSelectorQuery(String header, List<CorrelationKeySet> subSets) {
        StringBuffer filterQuery = new StringBuffer(header);
        if (subSets.size() == 1) {
            filterQuery.append(" and route._correlationKey = :s0");
        } else if (subSets.size() > 1) {
            filterQuery.append(" and route._correlationKey in(");
            for (int i = 0; i < subSets.size(); ++i) {
                if (i > 0) {
                    filterQuery.append(", ");
                }
                filterQuery.append(":s").append(i);
            }
            filterQuery.append(")");
        }
        return filterQuery.toString();
    }

    public String getCorrelatorId() {
        return CorrelatorDAOImpl.pcGet_correlatorKey(this);
    }

    public void setCorrelatorId(String newId) {
        CorrelatorDAOImpl.pcSet_correlatorKey(this, newId);
    }

    public void removeRoutes(String routeGroupId, ProcessInstanceDAO target) {
        ((ProcessInstanceDAOImpl)target).removeRoutes(routeGroupId);
    }

    void removeLocalRoutes(String routeGroupId, ProcessInstanceDAO target) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("removeLocalRoutes " + routeGroupId));
        }
        boolean flush = false;
        Iterator itr = CorrelatorDAOImpl.pcGet_routes(this).iterator();
        while (itr.hasNext()) {
            MessageRouteDAOImpl mr = (MessageRouteDAOImpl)itr.next();
            if (!mr.getGroupId().equals(routeGroupId) || !mr.getTargetInstance().equals(target)) continue;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("removing " + mr.getCorrelationKey() + " " + mr.getIndex() + " " + mr.getRoute()));
            }
            itr.remove();
            this.getEM().remove((Object)mr);
            flush = true;
        }
        if (flush) {
            this.getEM().flush();
        }
    }

    public Collection<MessageRouteDAO> getAllRoutes() {
        return new ArrayList<MessageRouteDAO>(CorrelatorDAOImpl.pcGet_routes(this));
    }

    public boolean checkRoute(CorrelationKeySet correlationKeySet) {
        return true;
    }

    static {
        pcFieldNames = new String[]{"_correlatorId", "_correlatorKey", "_exchanges", "_process", "_routes"};
        Class[] classArray = new Class[5];
        Class clazz = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = CorrelatorDAOImpl.class$("java.lang.Long"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = CorrelatorDAOImpl.class$("java.lang.String"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = CorrelatorDAOImpl.class$("java.util.Collection"));
        classArray[2] = clazz3;
        Class clazz4 = class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl : (class$Lorg$apache$ode$dao$jpa$ProcessDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.ProcessDAOImpl"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$util$Collection != null ? class$Ljava$util$Collection : (class$Ljava$util$Collection = CorrelatorDAOImpl.class$("java.util.Collection"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 5, 5, 10};
        Class clazz5 = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"CorrelatorDAOImpl", (PersistenceCapable)new CorrelatorDAOImpl());
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this._correlatorId = null;
        this._correlatorKey = null;
        this._exchanges = null;
        this._process = null;
        this._routes = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        CorrelatorDAOImpl correlatorDAOImpl = new CorrelatorDAOImpl();
        if (bl) {
            correlatorDAOImpl.pcClearFields();
        }
        correlatorDAOImpl.pcStateManager = stateManager;
        correlatorDAOImpl.pcCopyKeyFieldsFromObjectId(object);
        return correlatorDAOImpl;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        CorrelatorDAOImpl correlatorDAOImpl = new CorrelatorDAOImpl();
        if (bl) {
            correlatorDAOImpl.pcClearFields();
        }
        correlatorDAOImpl.pcStateManager = stateManager;
        return correlatorDAOImpl;
    }

    protected static int pcGetManagedFieldCount() {
        return 5;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._correlatorId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this._correlatorKey = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this._exchanges = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this._process = (ProcessDAOImpl)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this._routes = (Collection)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._correlatorId);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this._correlatorKey);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._exchanges);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this._process);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this._routes);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(CorrelatorDAOImpl correlatorDAOImpl, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this._correlatorId = correlatorDAOImpl._correlatorId;
                return;
            }
            case 1: {
                this._correlatorKey = correlatorDAOImpl._correlatorKey;
                return;
            }
            case 2: {
                this._exchanges = correlatorDAOImpl._exchanges;
                return;
            }
            case 3: {
                this._process = correlatorDAOImpl._process;
                return;
            }
            case 4: {
                this._routes = correlatorDAOImpl._routes;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        CorrelatorDAOImpl correlatorDAOImpl = (CorrelatorDAOImpl)object;
        if (correlatorDAOImpl.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(correlatorDAOImpl, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(0 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this._correlatorId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl != null ? class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl : (class$Lorg$apache$ode$dao$jpa$CorrelatorDAOImpl = CorrelatorDAOImpl.class$("org.apache.ode.dao.jpa.CorrelatorDAOImpl"));
        return new LongId(clazz, this._correlatorId);
    }

    private static final Long pcGet_correlatorId(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._correlatorId;
        }
        int n = pcInheritedFieldCount + 0;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._correlatorId;
    }

    private static final void pcSet_correlatorId(CorrelatorDAOImpl correlatorDAOImpl, Long l) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._correlatorId = l;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 0, (Object)correlatorDAOImpl._correlatorId, (Object)l, 0);
    }

    private static final String pcGet_correlatorKey(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._correlatorKey;
        }
        int n = pcInheritedFieldCount + 1;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._correlatorKey;
    }

    private static final void pcSet_correlatorKey(CorrelatorDAOImpl correlatorDAOImpl, String string) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._correlatorKey = string;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingStringField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 1, correlatorDAOImpl._correlatorKey, string, 0);
    }

    private static final Collection pcGet_exchanges(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._exchanges;
        }
        int n = pcInheritedFieldCount + 2;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._exchanges;
    }

    private static final void pcSet_exchanges(CorrelatorDAOImpl correlatorDAOImpl, Collection collection) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._exchanges = collection;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 2, correlatorDAOImpl._exchanges, (Object)collection, 0);
    }

    private static final ProcessDAOImpl pcGet_process(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._process;
        }
        int n = pcInheritedFieldCount + 3;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._process;
    }

    private static final void pcSet_process(CorrelatorDAOImpl correlatorDAOImpl, ProcessDAOImpl processDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._process = processDAOImpl;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 3, (Object)correlatorDAOImpl._process, (Object)processDAOImpl, 0);
    }

    private static final Collection pcGet_routes(CorrelatorDAOImpl correlatorDAOImpl) {
        if (correlatorDAOImpl.pcStateManager == null) {
            return correlatorDAOImpl._routes;
        }
        int n = pcInheritedFieldCount + 4;
        correlatorDAOImpl.pcStateManager.accessingField(n);
        return correlatorDAOImpl._routes;
    }

    private static final void pcSet_routes(CorrelatorDAOImpl correlatorDAOImpl, Collection collection) {
        if (correlatorDAOImpl.pcStateManager == null) {
            correlatorDAOImpl._routes = collection;
            return;
        }
        correlatorDAOImpl.pcStateManager.settingObjectField((PersistenceCapable)correlatorDAOImpl, pcInheritedFieldCount + 4, correlatorDAOImpl._routes, (Object)collection, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this._correlatorId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

