/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.dao.jpa.ProcessInstanceDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManagementDAOImpl
implements ProcessManagementDAO {
    private static final Log __log = LogFactory.getLog(ProcessManagementDAOImpl.class);
    private EntityManager em;

    public ProcessManagementDAOImpl(EntityManager em) {
        this.em = em;
    }

    public Object[] findFailedCountAndLastFailedDateForProcessId(BpelDAOConnection conn, String status, String processId) {
        Query query = this.em.createNamedQuery("COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID");
        query.setParameter("states", (Object)new InstanceFilter("status=" + status).convertFilterState());
        query.setParameter("processId", (Object)processId);
        return (Object[])query.getSingleResult();
    }

    public void prefetchActivityFailureCounts(Collection<ProcessInstanceDAO> instances) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("Prefetching activity failure counts for " + instances.size() + " instances."));
        }
        if (instances.isEmpty()) {
            return;
        }
        Query query = this.em.createNamedQuery("COUNT_ACTIVITY_RECOVERIES_BY_INSTANCES");
        query.setParameter("instances", instances);
        HashMap<Long, Long> countsByInstanceId = new HashMap<Long, Long>();
        for (Object instanceIdAndCount : query.getResultList()) {
            Object instanceId = ((Object[])instanceIdAndCount)[0];
            Object count = ((Object[])instanceIdAndCount)[0];
            countsByInstanceId.put((Long)instanceId, (Long)count);
        }
        for (ProcessInstanceDAO instance : instances) {
            Long count = (Long)countsByInstanceId.get(instance.getInstanceId());
            if (count == null) continue;
            ((ProcessInstanceDAOImpl)instance).setActivityFailureCount(count.intValue());
        }
    }

    public int countInstancesByPidAndString(BpelDAOConnection conn, QName pid, String status) {
        InstanceFilter instanceFilter = new InstanceFilter("status=" + status + " pid=" + pid);
        return conn.instanceQuery(instanceFilter).size();
    }

    public Map<ProcessManagementDAO.InstanceSummaryKey, Long> countInstancesSummary(Set<String> pids) {
        return new HashMap<ProcessManagementDAO.InstanceSummaryKey, Long>();
    }

    public Map<String, ProcessManagementDAO.FailedSummaryValue> findFailedCountAndLastFailedDateForProcessIds(Set<String> pids) {
        return new HashMap<String, ProcessManagementDAO.FailedSummaryValue>();
    }
}

