/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.dao.bpel.CorrelatorMessageDAO;
import org.apache.ode.dao.bpel.MessageDAO;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.dao.bpel.PartnerLinkDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.bpel.BpelDAO;
import org.apache.ode.dao.jpa.bpel.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.bpel.MessageDAOImpl;
import org.apache.ode.dao.jpa.bpel.MexProperty;
import org.apache.ode.dao.jpa.bpel.PartnerLinkDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.uuid.UUID;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BPEL_MESSAGE_EXCHANGE")
@NamedQueries(value={@NamedQuery(name="DELETE_MEXS_BY_PROCESS", query="delete from MessageExchangeDAOImpl as m where m._process = :process"), @NamedQuery(name="SELECT_MEX_IDS_BY_PROCESS", query="select m._id from MessageExchangeDAOImpl as m where m._process = :process")})
public class MessageExchangeDAOImpl
extends BpelDAO
implements MessageExchangeDAO,
CorrelatorMessageDAO {
    private static final Log __log = LogFactory.getLog(MessageExchangeDAOImpl.class);
    public static final String DELETE_MEXS_BY_PROCESS = "DELETE_MEXS_BY_PROCESS";
    public static final String SELECT_MEX_IDS_BY_PROCESS = "SELECT_MEX_IDS_BY_PROCESS";
    @Id
    @Column(name="MESSAGE_EXCHANGE_ID")
    private String _id;
    @Basic
    @Column(name="CALLEE")
    private String _callee;
    @Basic
    @Column(name="CHANNEL")
    private String _channel;
    @Basic
    @Column(name="CORRELATION_ID")
    private String _correlationId;
    @Basic
    @Column(name="CORRELATION_STATUS")
    private String _correlationStatus;
    @Basic
    @Column(name="CREATE_TIME")
    private Date _createTime;
    @Basic
    @Column(name="DIRECTION")
    private char _direction;
    @Lob
    @Column(name="EPR")
    private String _epr;
    @Transient
    private Element _eprElement;
    @Basic
    @Column(name="FAULT")
    private String _fault;
    @Basic
    @Column(name="FAULT_EXPLANATION")
    private String _faultExplanation;
    @Basic
    @Column(name="OPERATION")
    private String _operation;
    @Basic
    @Column(name="PARTNER_LINK_MODEL_ID")
    private int _partnerLinkModelId;
    @Basic
    @Column(name="PATTERN")
    private String _pattern;
    @Basic
    @Column(name="PORT_TYPE")
    private String _portType;
    @Basic
    @Column(name="PROPAGATE_TRANS")
    private boolean _propagateTransactionFlag;
    @Basic
    @Column(name="STATUS")
    private String _status;
    @Basic
    @Column(name="CORRELATION_KEYS")
    private String _correlationKeys;
    @Basic
    @Column(name="PIPED_ID")
    private String _pipedMessageExchangeId;
    @Basic
    @Column(name="SUBSCRIBER_COUNT")
    private int _subscriberCount;
    @OneToMany(targetEntity=MexProperty.class, mappedBy="_mex", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Collection<MexProperty> _props = new ArrayList<MexProperty>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PROCESS_INSTANCE_ID")
    private ProcessInstanceDAOImpl _processInst;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PARTNER_LINK_ID")
    private PartnerLinkDAOImpl _partnerLink;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PROCESS_ID")
    private ProcessDAOImpl _process;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="REQUEST_MESSAGE_ID")
    private MessageDAOImpl _request;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="RESPONSE_MESSAGE_ID")
    private MessageDAOImpl _response;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="CORR_ID")
    private CorrelatorDAOImpl _correlator;

    public MessageExchangeDAOImpl() {
    }

    public MessageExchangeDAOImpl(char direction) {
        this._direction = direction;
        this._id = new UUID().toString();
    }

    public MessageDAO createMessage(QName type) {
        MessageDAOImpl ret = new MessageDAOImpl(type, this);
        return ret;
    }

    public QName getCallee() {
        return this._callee == null ? null : QName.valueOf(this._callee);
    }

    public String getChannel() {
        return this._channel;
    }

    public String getCorrelationId() {
        return this._correlationId;
    }

    public String getCorrelationStatus() {
        return this._correlationStatus;
    }

    public Date getCreateTime() {
        return this._createTime;
    }

    public char getDirection() {
        return this._direction;
    }

    public Element getEPR() {
        if (this._eprElement == null && this._epr != null && !"".equals(this._epr)) {
            try {
                this._eprElement = DOMUtils.stringToDOM((String)this._epr);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._eprElement;
    }

    public QName getFault() {
        return this._fault == null ? null : QName.valueOf(this._fault);
    }

    public String getFaultExplanation() {
        return this._faultExplanation;
    }

    public ProcessInstanceDAO getInstance() {
        return this._processInst;
    }

    public String getMessageExchangeId() {
        return this._id;
    }

    public String getOperation() {
        return this._operation;
    }

    public PartnerLinkDAO getPartnerLink() {
        return this._partnerLink;
    }

    public int getPartnerLinkModelId() {
        return this._partnerLinkModelId;
    }

    public String getPattern() {
        return this._pattern;
    }

    public QName getPortType() {
        return this._portType == null ? null : QName.valueOf(this._portType);
    }

    public ProcessDAO getProcess() {
        return this._process;
    }

    public boolean getPropagateTransactionFlag() {
        return this._propagateTransactionFlag;
    }

    public String getProperty(String key) {
        for (MexProperty prop : this._props) {
            if (!prop.getPropertyKey().equals(key)) continue;
            return prop.getPropertyValue();
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        HashSet<String> propNames = new HashSet<String>();
        for (MexProperty prop : this._props) {
            propNames.add(prop.getPropertyKey());
        }
        return propNames;
    }

    public MessageDAO getRequest() {
        return this._request;
    }

    public MessageDAO getResponse() {
        return this._response;
    }

    public String getStatus() {
        return this._status;
    }

    public void setCallee(QName callee) {
        this._callee = callee.toString();
    }

    public void setChannel(String channel) {
        this._channel = channel;
    }

    public void setCorrelationId(String correlationId) {
        this._correlationId = correlationId;
    }

    public void setCorrelationStatus(String cstatus) {
        this._correlationStatus = cstatus;
    }

    public void setEPR(Element epr) {
        this._eprElement = epr;
        this._epr = DOMUtils.domToString((Node)epr);
    }

    public void setFault(QName faultType) {
        this._fault = faultType == null ? null : faultType.toString();
    }

    public void setFaultExplanation(String explanation) {
        if (explanation != null && explanation.length() > 255) {
            explanation = explanation.substring(0, 254);
        }
        this._faultExplanation = explanation;
    }

    public void setInstance(ProcessInstanceDAO dao) {
        this._processInst = (ProcessInstanceDAOImpl)dao;
    }

    public void setOperation(String opname) {
        this._operation = opname;
    }

    public void setPartnerLink(PartnerLinkDAO plinkDAO) {
        this._partnerLink = (PartnerLinkDAOImpl)plinkDAO;
    }

    public void setPartnerLinkModelId(int modelId) {
        this._partnerLinkModelId = modelId;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public void setPortType(QName porttype) {
        this._portType = porttype.toString();
    }

    public void setProcess(ProcessDAO process) {
        this._process = (ProcessDAOImpl)process;
    }

    public void setProperty(String key, String value) {
        this._props.add(new MexProperty(key, value, this));
    }

    public void setRequest(MessageDAO msg) {
        this._request = (MessageDAOImpl)msg;
    }

    public void setResponse(MessageDAO msg) {
        this._response = (MessageDAOImpl)msg;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("-----> response data: " + DOMUtils.domToString((Node)this._response.getData()) + ", id: " + this._id));
        }
    }

    public void setStatus(String status) {
        this._status = status;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("-------> status " + this._status + ", id :" + this._id));
        }
    }

    public String getPipedMessageExchangeId() {
        return this._pipedMessageExchangeId;
    }

    public void setPipedMessageExchangeId(String pipedMessageExchangeId) {
        this._pipedMessageExchangeId = pipedMessageExchangeId;
    }

    void setCorrelationKeySet(CorrelationKeySet correlationKeySet) {
        this._correlationKeys = correlationKeySet.toCanonicalString();
    }

    CorrelationKeySet getCorrelationKeySet() {
        return new CorrelationKeySet(this._correlationKeys);
    }

    public CorrelationKey getCorrelationKey() {
        if (this._correlationKeys == null) {
            return null;
        }
        return (CorrelationKey)this.getCorrelationKeySet().iterator().next();
    }

    public void setCorrelationKey(CorrelationKey ckey) {
        this._correlationKeys = ckey.toCanonicalString();
    }

    public void release(boolean doClean) {
        if (doClean) {
            this.deleteMessages();
        }
    }

    public void releasePremieMessages() {
    }

    public void deleteMessages() {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Deleting message on MEX release.");
        }
        this.getEM().remove((Object)this);
    }

    public CorrelatorDAOImpl getCorrelator() {
        return this._correlator;
    }

    public void setCorrelator(CorrelatorDAOImpl correlator) {
        this._correlator = correlator;
    }

    public int getSubscriberCount() {
        return this._subscriberCount;
    }

    public void setSubscriberCount(int subscriberCount) {
        this._subscriberCount = subscriberCount;
    }

    public void incrementSubscriberCount() {
        ++this._subscriberCount;
    }

    public void release() {
    }

    public void setCreateTime(Date createTime) {
        this._createTime = createTime;
    }
}

