/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.dao.bpel.CorrelatorDAO;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.jpa.bpel.BpelDAO;
import org.apache.ode.dao.jpa.bpel.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BPEL_PROCESS")
@NamedQueries(value={@NamedQuery(name="ActiveInstances", query="select i from ProcessInstanceDAOImpl as i where i._process = :process and i._state = :state"), @NamedQuery(name="InstanceByCKey", query="select cs._scope._processInstance from CorrelationSetDAOImpl as cs where cs._correlationKey = :ckey"), @NamedQuery(name="CorrelatorByKey", query="select c from CorrelatorDAOImpl as c where c._correlatorKey = :ckey and c._process = :process")})
public class ProcessDAOImpl
extends BpelDAO
implements ProcessDAO {
    private static final Log __log = LogFactory.getLog(ProcessDAOImpl.class);
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Basic
    @Column(name="PROCESS_ID")
    private String _processId;
    @Basic
    @Column(name="PROCESS_TYPE")
    private String _processType;
    @Basic
    @Column(name="GUID")
    private String _guid;
    @Basic
    @Column(name="VERSION")
    private long _version;
    @OneToMany(targetEntity=CorrelatorDAOImpl.class, mappedBy="_process", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<CorrelatorDAOImpl> _correlators = new ArrayList<CorrelatorDAOImpl>();

    public ProcessDAOImpl() {
    }

    public ProcessDAOImpl(QName pid, QName type, String guid, long version) {
        this._processId = pid.toString();
        this._processType = type.toString();
        this._guid = guid;
        this._version = version;
    }

    public Serializable getId() {
        return this._id;
    }

    public void setId(Long id) {
        this._id = id;
    }

    public CorrelatorDAO addCorrelator(String correlator) {
        CorrelatorDAOImpl corr = new CorrelatorDAOImpl(correlator, this);
        this._correlators.add(corr);
        return corr;
    }

    public CorrelatorDAO getCorrelator(String correlatorId) {
        Query qry = this.getEM().createNamedQuery("CorrelatorByKey");
        qry.setParameter("ckey", (Object)correlatorId);
        qry.setParameter("process", (Object)this);
        List res = qry.getResultList();
        if (res.size() == 0) {
            return null;
        }
        return (CorrelatorDAO)res.get(0);
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO instantiatingCorrelator) {
        ProcessInstanceDAOImpl inst = new ProcessInstanceDAOImpl((CorrelatorDAOImpl)instantiatingCorrelator, this);
        this.getEM().persist((Object)inst);
        return inst;
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO instantiatingCorrelator, MessageExchangeDAO mex) {
        ProcessInstanceDAOImpl inst = new ProcessInstanceDAOImpl((CorrelatorDAOImpl)instantiatingCorrelator, this);
        this.getEM().persist((Object)inst);
        return inst;
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey ckey) {
        Query qry = this.getEM().createNamedQuery("InstanceByCKey");
        qry.setParameter("ckey", (Object)ckey.toCanonicalString());
        return qry.getResultList();
    }

    public ProcessInstanceDAO getInstance(Long iid) {
        return (ProcessInstanceDAO)this.getEM().find(ProcessInstanceDAOImpl.class, (Object)iid);
    }

    public QName getProcessId() {
        return QName.valueOf(this._processId);
    }

    public QName getType() {
        return QName.valueOf(this._processType);
    }

    public void deleteProcessAndRoutes() {
        List instanceIds = this.getEM().createNamedQuery("SELECT_INSTANCE_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(instanceIds.iterator(), this.getEM().createNamedQuery("DELETE_MESSAGE_ROUTES_BY_INSTANCE_IDS"), "instanceIds");
        this.deleteInstances(Integer.MAX_VALUE);
        this.getEM().createNamedQuery("DELETE_CORRELATORS_BY_PROCESS").setParameter("process", (Object)this).executeUpdate();
        this.getEM().remove((Object)this);
        this.getEM().flush();
    }

    private int deleteInstances(int transactionSize) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)"Cleaning up process data.");
        }
        this.deleteEvents();
        this.deleteCorrelations();
        this.deleteMessages();
        this.deleteVariables();
        this.deleteProcessInstances();
        return 0;
    }

    private void deleteProcessInstances() {
        List faultIds = this.getEM().createNamedQuery("SELECT_FAULT_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(faultIds.iterator(), this.getEM().createNamedQuery("DELETE_FAULTS_BY_IDS"), "ids");
        List instanceIds = this.getEM().createNamedQuery("SELECT_INSTANCE_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(instanceIds.iterator(), this.getEM().createNamedQuery("DELETE_ACTIVITY_RECOVERIES_BY_IDS"), "ids");
        this.getEM().createNamedQuery("DELETE_INSTANCES_BY_PROCESS").setParameter("process", (Object)this).executeUpdate();
    }

    private void deleteVariables() {
        List xmlDataIds = this.getEM().createNamedQuery("SELECT_XMLDATA_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(xmlDataIds.iterator(), this.getEM().createNamedQuery("DELETE_XML_DATA_PROPERTIES_BY_XML_DATA_IDS"), "xmlDataIds");
        List scopeIds = this.getEM().createNamedQuery("SELECT_SCOPE_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(scopeIds.iterator(), this.getEM().createNamedQuery("DELETE_XMLDATA_BY_SCOPE_IDS"), "scopeIds");
        this.batchUpdateByIds(scopeIds.iterator(), this.getEM().createNamedQuery("DELETE_PARTNER_LINKS_BY_SCOPE_IDS"), "scopeIds");
        this.batchUpdateByIds(scopeIds.iterator(), this.getEM().createNamedQuery("DELETE_SCOPES_BY_SCOPE_IDS"), "ids");
    }

    private void deleteMessages() {
        List mexIds = this.getEM().createNamedQuery("SELECT_MEX_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(mexIds.iterator(), this.getEM().createNamedQuery("DELETE_MESSAGES_BY_MEXIDS"), "mexIds");
        this.batchUpdateByIds(mexIds.iterator(), this.getEM().createNamedQuery("DELETE_MEX_PROPERTIES_BY_MEX_IDS"), "mexIds");
        this.getEM().createNamedQuery("DELETE_MEXS_BY_PROCESS").setParameter("process", (Object)this).executeUpdate();
    }

    private void deleteCorrelations() {
        List corrSetIds = this.getEM().createNamedQuery("SELECT_CORRELATION_SET_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(corrSetIds.iterator(), this.getEM().createNamedQuery("DELETE_CORSET_PROPERTIES_BY_PROPERTY_IDS"), "corrSetIds");
        this.batchUpdateByIds(corrSetIds.iterator(), this.getEM().createNamedQuery("DELETE_CORRELATION_SETS_BY_IDS"), "ids");
    }

    private void deleteEvents() {
        List eventIds = this.getEM().createNamedQuery("SELECT_EVENT_IDS_BY_PROCESS").setParameter("process", (Object)this).getResultList();
        this.batchUpdateByIds(eventIds.iterator(), this.getEM().createNamedQuery("DELETE_EVENTS_BY_IDS"), "ids");
    }

    public int getNumInstances() {
        Long instanceCount = (Long)this.getSingleResult(this.getEM().createNamedQuery("COUNT_INSTANCE_IDS_BY_PROCESS").setParameter("process", (Object)this));
        return instanceCount == null ? 0 : instanceCount.intValue();
    }

    public long getVersion() {
        return this._version;
    }

    public void instanceCompleted(ProcessInstanceDAO instance) {
    }

    public void removeRoutes(String routeId, ProcessInstanceDAO target) {
        for (CorrelatorDAOImpl c : this._correlators) {
            c.removeLocalRoutes(routeId, target);
        }
    }

    public String getGuid() {
        return this._guid;
    }

    public Collection<ProcessInstanceDAO> getActiveInstances() {
        Query qry = this.getEM().createNamedQuery("ActiveInstances");
        qry.setParameter("process", (Object)this);
        qry.setParameter("state", (Object)20);
        return qry.getResultList();
    }
}

