/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.dao.bpel.ActivityRecoveryDAO;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.CorrelatorDAO;
import org.apache.ode.dao.bpel.FaultDAO;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ScopeDAO;
import org.apache.ode.dao.bpel.ScopeStateEnum;
import org.apache.ode.dao.bpel.XmlDataDAO;
import org.apache.ode.dao.jpa.bpel.ActivityRecoveryDAOImpl;
import org.apache.ode.dao.jpa.bpel.BpelDAO;
import org.apache.ode.dao.jpa.bpel.BpelDAOConnectionImpl;
import org.apache.ode.dao.jpa.bpel.CorrelatorDAOImpl;
import org.apache.ode.dao.jpa.bpel.FaultDAOImpl;
import org.apache.ode.dao.jpa.bpel.MessageExchangeDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessDAOImpl;
import org.apache.ode.dao.jpa.bpel.ScopeDAOImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="BPEL_PROCESS_INSTANCE")
@NamedQueries(value={@NamedQuery(name="DELETE_INSTANCES_BY_PROCESS", query="delete from ProcessInstanceDAOImpl as i where i._process = :process"), @NamedQuery(name="SELECT_INSTANCE_IDS_BY_PROCESS", query="select i._instanceId from ProcessInstanceDAOImpl as i where i._process = :process"), @NamedQuery(name="COUNT_INSTANCE_IDS_BY_PROCESS", query="select count(i._instanceId) from ProcessInstanceDAOImpl as i where i._process = :process"), @NamedQuery(name="SELECT_FAULT_IDS_BY_PROCESS", query="select i._faultId from ProcessInstanceDAOImpl as i where i._process = :process and i._faultId is not null"), @NamedQuery(name="COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID", query="select count(i._instanceId), max(i._lastRecovery) from ProcessInstanceDAOImpl as i where i._process._processId = :processId and i._state in(:states) and exists(select r from ActivityRecoveryDAOImpl r where i = r._instance)")})
public class ProcessInstanceDAOImpl
extends BpelDAO
implements ProcessInstanceDAO {
    private static final Log __log = LogFactory.getLog(ProcessInstanceDAOImpl.class);
    public static final String DELETE_INSTANCES_BY_PROCESS = "DELETE_INSTANCES_BY_PROCESS";
    public static final String SELECT_INSTANCE_IDS_BY_PROCESS = "SELECT_INSTANCE_IDS_BY_PROCESS";
    public static final String COUNT_INSTANCE_IDS_BY_PROCESS = "COUNT_INSTANCE_IDS_BY_PROCESS";
    public static final String SELECT_FAULT_IDS_BY_PROCESS = "SELECT_FAULT_IDS_BY_PROCESS";
    public static final String COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID = "COUNT_FAILED_INSTANCES_BY_STATUS_AND_PROCESS_ID";
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _instanceId;
    @Basic
    @Column(name="LAST_RECOVERY_DATE")
    private Date _lastRecovery;
    @Basic
    @Column(name="LAST_ACTIVE_TIME")
    private Date _lastActive;
    @Basic
    @Column(name="INSTANCE_STATE")
    private short _state;
    @Basic
    @Column(name="PREVIOUS_STATE")
    private short _previousState;
    @Lob
    @Column(name="EXECUTION_STATE")
    private byte[] _executionState;
    @Basic
    @Column(name="SEQUENCE")
    private long _sequence;
    @Basic
    @Column(name="DATE_CREATED")
    private Date _dateCreated = new Date();
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="ROOT_SCOPE_ID")
    private ScopeDAOImpl _rootScope;
    @OneToMany(targetEntity=ScopeDAOImpl.class, mappedBy="_processInstance", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    private Collection<ScopeDAO> _scopes = new ArrayList<ScopeDAO>();
    @OneToMany(targetEntity=ActivityRecoveryDAOImpl.class, mappedBy="_instance", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<ActivityRecoveryDAO> _recoveries = new ArrayList<ActivityRecoveryDAO>();
    @Basic
    @Column(name="FAULT_ID", insertable=false, updatable=false, nullable=true)
    private Long _faultId;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinColumn(name="FAULT_ID")
    private FaultDAOImpl _fault;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PROCESS_ID")
    private ProcessDAOImpl _process;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="INSTANTIATING_CORRELATOR_ID")
    private CorrelatorDAOImpl _instantiatingCorrelator;
    @OneToMany(targetEntity=MessageExchangeDAOImpl.class, mappedBy="_processInst", fetch=FetchType.LAZY)
    private Collection<MessageExchangeDAO> _messageExchanges = new ArrayList<MessageExchangeDAO>();
    private transient int _activityFailureCount = -1;

    public ProcessInstanceDAOImpl() {
    }

    public ProcessInstanceDAOImpl(CorrelatorDAOImpl correlator, ProcessDAOImpl process) {
        this._instantiatingCorrelator = correlator;
        this._process = process;
    }

    public void createActivityRecovery(String channel, long activityId, String reason, Date dateTime, Element data, String[] actions, int retries) {
        ActivityRecoveryDAOImpl ar = new ActivityRecoveryDAOImpl(channel, activityId, reason, dateTime, data, actions, retries);
        this._recoveries.add(ar);
        ar.setInstance(this);
        this._lastRecovery = dateTime;
    }

    public ScopeDAO createScope(ScopeDAO parentScope, String name, int scopeModelId) {
        ScopeDAOImpl ret = new ScopeDAOImpl((ScopeDAOImpl)parentScope, name, scopeModelId, this);
        ret.setState(ScopeStateEnum.ACTIVE);
        this._scopes.add(ret);
        this._rootScope = parentScope == null ? ret : this._rootScope;
        this.getEM().persist((Object)ret);
        return ret;
    }

    public Collection<CorrelationSetDAO> selectCorrelationSets(Collection<ProcessInstanceDAO> instances) {
        return this.getEM().createNamedQuery("SELECT_CORRELATION_SETS_BY_INSTANCES").setParameter("instances", instances).getResultList();
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories) {
        this.delete(cleanupCategories, true);
    }

    public void delete(Set<ProcessConf.CLEANUP_CATEGORY> cleanupCategories, boolean deleteMyRoleMex) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Cleaning up instance Data with " + cleanupCategories));
        }
        this.setExecutionState(null);
        if (this.getEM() != null) {
            if (!cleanupCategories.isEmpty()) {
                this.getEM().flush();
            }
            if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.EVENTS)) {
                this.deleteEvents();
            }
            if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS)) {
                this.deleteCorrelations();
            }
            if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.MESSAGES)) {
                this.deleteMessageRoutes();
            }
            if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.VARIABLES)) {
                this.deleteVariables();
            }
            if (cleanupCategories.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE)) {
                this.deleteInstance();
            }
            this.getEM().flush();
        }
    }

    private void deleteInstance() {
        if (this._fault != null) {
            this.getEM().remove((Object)this._fault);
        }
        this.getEM().remove((Object)this);
    }

    private void deleteVariables() {
        List xmlDataIds = this.getEM().createNamedQuery("SELECT_XMLDATA_IDS_BY_INSTANCE").setParameter("instance", (Object)this).getResultList();
        this.batchUpdateByIds(xmlDataIds.iterator(), this.getEM().createNamedQuery("DELETE_XML_DATA_PROPERTIES_BY_XML_DATA_IDS"), "xmlDataIds");
        List scopeIds = this.getEM().createNamedQuery("SELECT_SCOPE_IDS_BY_INSTANCE").setParameter("instance", (Object)this).getResultList();
        this.batchUpdateByIds(scopeIds.iterator(), this.getEM().createNamedQuery("DELETE_XMLDATA_BY_SCOPE_IDS"), "scopeIds");
        this.batchUpdateByIds(scopeIds.iterator(), this.getEM().createNamedQuery("DELETE_PARTNER_LINKS_BY_SCOPE_IDS"), "scopeIds");
        this.batchUpdateByIds(scopeIds.iterator(), this.getEM().createNamedQuery("DELETE_SCOPES_BY_SCOPE_IDS"), "ids");
    }

    private void deleteMessageRoutes() {
        this.getEM().createNamedQuery("DELETE_MESSAGE_ROUTES_BY_INSTANCE").setParameter("instance", (Object)this).executeUpdate();
    }

    private void deleteCorrelations() {
        List corrSetIds = this.getEM().createNamedQuery("SELECT_CORRELATION_SET_IDS_BY_INSTANCE").setParameter("instance", (Object)this).getResultList();
        this.batchUpdateByIds(corrSetIds.iterator(), this.getEM().createNamedQuery("DELETE_CORSET_PROPERTIES_BY_PROPERTY_IDS"), "corrSetIds");
        this.batchUpdateByIds(corrSetIds.iterator(), this.getEM().createNamedQuery("DELETE_CORRELATION_SETS_BY_IDS"), "ids");
    }

    private void deleteEvents() {
        this.getEM().createNamedQuery("DELETE_EVENTS_BY_INSTANCE").setParameter("instance", (Object)this).executeUpdate();
    }

    public void deleteActivityRecovery(String channel) {
        ActivityRecoveryDAOImpl toRemove = null;
        for (ActivityRecoveryDAO _recovery : this._recoveries) {
            ActivityRecoveryDAOImpl arElement = (ActivityRecoveryDAOImpl)_recovery;
            if (!arElement.getChannel().equals(channel)) continue;
            toRemove = arElement;
            break;
        }
        if (toRemove != null) {
            this.getEM().remove(toRemove);
            this._recoveries.remove(toRemove);
        }
    }

    public void finishCompletion() {
        assert (ProcessState.isFinished((short)this.getState()));
    }

    public long genMonotonic() {
        return this._sequence++;
    }

    public int getActivityFailureCount() {
        if (this._activityFailureCount == -1) {
            this._activityFailureCount = this._recoveries.size();
        }
        return this._activityFailureCount;
    }

    public void setActivityFailureCount(int activityFailureCount) {
        this._activityFailureCount = activityFailureCount;
    }

    public Date getActivityFailureDateTime() {
        return this._lastRecovery;
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        return this._recoveries;
    }

    public CorrelationSetDAO getCorrelationSet(String name) {
        throw new UnsupportedOperationException();
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        return new HashSet<CorrelationSetDAO>();
    }

    public Date getCreateTime() {
        return this._dateCreated;
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        return null;
    }

    public byte[] getExecutionState() {
        return this._executionState;
    }

    public FaultDAO getFault() {
        return this._fault;
    }

    public Long getInstanceId() {
        return this._instanceId;
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        return this._instantiatingCorrelator;
    }

    public Date getLastActiveTime() {
        return this._lastActive;
    }

    public short getPreviousState() {
        return this._previousState;
    }

    public ProcessDAO getProcess() {
        return this._process;
    }

    public ScopeDAO getRootScope() {
        return this._rootScope;
    }

    public ScopeDAO getScope(Long scopeInstanceId) {
        return (ScopeDAO)this.getEM().find(ScopeDAOImpl.class, (Object)scopeInstanceId);
    }

    public Collection<ScopeDAO> getScopes(String scopeName) {
        ArrayList<ScopeDAO> ret = new ArrayList<ScopeDAO>();
        for (ScopeDAO sElement : this._scopes) {
            if (!sElement.getName().equals(scopeName)) continue;
            ret.add(sElement);
        }
        return ret;
    }

    public Collection<ScopeDAO> getScopes() {
        return this._scopes;
    }

    public short getState() {
        return this._state;
    }

    public XmlDataDAO[] getVariables(String variableName, int scopeModelId) {
        ArrayList<XmlDataDAO> results = new ArrayList<XmlDataDAO>();
        for (ScopeDAO sElement : this._scopes) {
            XmlDataDAO var;
            if (sElement.getModelId() != scopeModelId || (var = sElement.getVariable(variableName)) == null) continue;
            results.add(var);
        }
        return results.toArray(new XmlDataDAO[results.size()]);
    }

    public void insertBpelEvent(ProcessInstanceEvent event) {
        this.getConn().insertBpelEvent((BpelEvent)event, this.getProcess(), this);
    }

    public void setExecutionState(byte[] execState) {
        this._executionState = execState;
    }

    public void setFault(FaultDAO fault) {
        this._fault = (FaultDAOImpl)fault;
    }

    public void setFault(QName faultName, String explanation, int faultLineNo, int activityId, Element faultMessage) {
        this._fault = new FaultDAOImpl(faultName, explanation, faultLineNo, activityId, faultMessage);
    }

    public void setLastActiveTime(Date dt) {
        this._lastActive = dt;
    }

    public void setState(short state) {
        this._previousState = this._state;
        this._state = state;
    }

    void removeRoutes(String routeGroupId) {
        this._process.removeRoutes(routeGroupId, this);
    }

    public BpelDAOConnection getConnection() {
        return BpelDAOConnectionImpl.getThreadLocal().get();
    }

    public Collection<String> getMessageExchangeIds() {
        HashSet<String> c = new HashSet<String>();
        for (MessageExchangeDAO m : this._messageExchanges) {
            c.add(m.getMessageExchangeId());
        }
        return c;
    }
}

