/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.dao.jpa.store.ConfStoreDAO;
import org.apache.ode.dao.jpa.store.DeploymentUnitDaoImpl;
import org.apache.ode.dao.jpa.store.ProcessConfPropertyDaoImpl;
import org.apache.ode.dao.store.ProcessConfDAO;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="STORE_PROCESS")
public class ProcessConfDaoImpl
extends ConfStoreDAO
implements ProcessConfDAO {
    @ManyToOne(targetEntity=DeploymentUnitDaoImpl.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="DU")
    private DeploymentUnitDaoImpl _du;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @MapKey(name="_key")
    @JoinTable(name="STORE_PROC_TO_PROP", inverseJoinColumns={@JoinColumn(name="STORE_PROPERTY_ID")})
    private Map<String, ProcessConfPropertyDaoImpl> _properties = new HashMap<String, ProcessConfPropertyDaoImpl>();
    @Id
    @Column(name="PID")
    private String _processId;
    @Basic
    @Column(name="TYPE")
    private String _type;
    @Basic
    @Column(name="VERSION")
    private long _version;
    @Basic
    @Column(name="STATE")
    private String _state;

    public DeploymentUnitDaoImpl getDeploymentUnit() {
        return this._du;
    }

    public void setDeploymentUnit(DeploymentUnitDaoImpl du) {
        this._du = du;
    }

    public String getPID_() {
        return this._processId;
    }

    public void setPID_(String processId) {
        this._processId = processId;
    }

    public String getType_() {
        return this._type;
    }

    public void setType_(String type) {
        this._type = type;
    }

    public long getVersion() {
        return this._version;
    }

    public void setVersion(long version) {
        this._version = version;
    }

    public String getState_() {
        return this._state;
    }

    public void setState_(String state) {
        this._state = state;
    }

    public QName getPID() {
        return QName.valueOf(this.getPID_());
    }

    public void setPID(QName pid) {
        this.setPID_(pid.toString());
    }

    public void setState(ProcessState state) {
        this.setState_(state.toString());
    }

    public void setProperty(QName name, String content) {
        ProcessConfPropertyDaoImpl prop = new ProcessConfPropertyDaoImpl();
        prop.setKey(name.toString());
        prop.setValue(content);
        this.getEM().persist((Object)prop);
        this._properties.put(name.toString(), prop);
        this.getEM().persist((Object)this);
    }

    @Override
    public void delete() {
        super.delete();
    }

    public QName getType() {
        return QName.valueOf(this.getType_());
    }

    public void setType(QName type) {
        this.setType_(type.toString());
    }

    public ProcessState getState() {
        return ProcessState.valueOf((String)this.getState_());
    }

    public String getProperty(QName name) {
        return this._properties.get(name.toString()).getValue();
    }

    public Collection<QName> getPropertyNames() {
        return CollectionsX.transform(new ArrayList(), this._properties.keySet(), (UnaryFunction)new UnaryFunction<String, QName>(){

            public QName apply(String x) {
                return QName.valueOf(x);
            }
        });
    }
}

