/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa;

import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.DAOConnection;
import org.apache.ode.dao.jpa.JpaOperator;

public class JpaConnection
implements DAOConnection {
    private static final Log __log = LogFactory.getLog(JpaConnection.class);
    protected final EntityManager _em;
    protected final TransactionManager _mgr;
    protected final JpaTxContext _txCtx;
    protected final JpaOperator _operator;

    public JpaConnection(EntityManager em, TransactionManager mgr, JpaOperator operator) {
        this._em = em;
        this._mgr = mgr;
        this._txCtx = mgr != null ? new JpaJtaContext() : new JpaNonTxContext();
        this._operator = operator;
    }

    public EntityManager getEntityManager() {
        return this._em;
    }

    public JpaOperator getJPADaoOperator() {
        return this._operator;
    }

    public void close() {
    }

    public boolean isClosed() {
        return this._em == null ? true : !this._em.isOpen();
    }

    public void clearOnComplete() {
        try {
            this._mgr.getTransaction().registerSynchronization(new Synchronization(){

                public void afterCompletion(int i) {
                    JpaConnection.this._em.clear();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)"-------> clear the entity manager");
                    }
                }

                public void beforeCompletion() {
                }
            });
        }
        catch (Exception e) {
            __log.error((Object)"Error adding commit synchronizer", (Throwable)e);
        }
    }

    class JpaNonTxContext
    implements JpaTxContext {
        JpaNonTxContext() {
        }

        public void begin() {
            JpaConnection.this._em.getTransaction().begin();
        }

        public void commit() {
            JpaConnection.this._em.getTransaction().commit();
            JpaConnection.this._em.clear();
        }

        public void rollback() {
            JpaConnection.this._em.getTransaction().rollback();
            JpaConnection.this._em.clear();
        }
    }

    class JpaJtaContext
    implements JpaTxContext {
        JpaJtaContext() {
        }

        public void begin() {
            try {
                if (JpaConnection.this._mgr.getStatus() == 0) {
                    JpaConnection.this._em.joinTransaction();
                    JpaConnection.this.clearOnComplete();
                }
            }
            catch (SystemException se) {
                __log.error((Object)se);
            }
        }

        public void commit() {
        }

        public void rollback() {
            try {
                if (JpaConnection.this._mgr.getStatus() == 0) {
                    JpaConnection.this._mgr.setRollbackOnly();
                }
            }
            catch (Exception ex) {
                __log.error((Object)"Unable to set rollbackOnly", (Throwable)ex);
            }
        }
    }

    protected static interface JpaTxContext {
        public void begin();

        public void commit();

        public void rollback();
    }
}

