/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.store;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.dao.jpa.JpaConnection;
import org.apache.ode.dao.jpa.JpaOperator;
import org.apache.ode.dao.jpa.store.DeploymentUnitDaoImpl;
import org.apache.ode.dao.jpa.store.VersionTrackerDAOImpl;
import org.apache.ode.dao.store.ConfStoreDAOConnection;
import org.apache.ode.dao.store.DeploymentUnitDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfStoreDAOConnectionImpl
extends JpaConnection
implements ConfStoreDAOConnection {
    private static Log LOG = LogFactory.getLog(ConfStoreDAOConnectionImpl.class);
    static final ThreadLocal<ConfStoreDAOConnectionImpl> _connections = new ThreadLocal();

    public ConfStoreDAOConnectionImpl(EntityManager mgr, TransactionManager txMgr, JpaOperator operator) {
        super(mgr, txMgr, operator);
    }

    @Override
    public void close() {
    }

    public DeploymentUnitDAO createDeploymentUnit(String name) {
        this._txCtx.begin();
        DeploymentUnitDaoImpl du = new DeploymentUnitDaoImpl();
        du.setName(name);
        du.setDeployDate(new Date());
        this._em.persist((Object)du);
        this._txCtx.commit();
        return du;
    }

    public DeploymentUnitDAO getDeploymentUnit(String name) {
        this._txCtx.begin();
        DeploymentUnitDAO dao = (DeploymentUnitDAO)this._em.find(DeploymentUnitDaoImpl.class, (Object)name);
        this._txCtx.commit();
        return dao;
    }

    public Collection<DeploymentUnitDAO> getDeploymentUnits() {
        this._txCtx.begin();
        List dao = this._em.createQuery("SELECT du from DeploymentUnitDaoImpl du").getResultList();
        this._txCtx.commit();
        return dao;
    }

    public long getNextVersion() {
        this._txCtx.begin();
        List res = this._em.createQuery("select v from VersionTrackerDAOImpl v").getResultList();
        this._txCtx.commit();
        if (res.size() == 0) {
            return 1L;
        }
        VersionTrackerDAOImpl vt = (VersionTrackerDAOImpl)res.get(0);
        return vt.getVersion() + 1L;
    }

    public void setVersion(long version) {
        this._txCtx.begin();
        List res = this._em.createQuery("select v from VersionTrackerDAOImpl v").getResultList();
        VersionTrackerDAOImpl vt = res.size() == 0 ? new VersionTrackerDAOImpl() : (VersionTrackerDAOImpl)res.get(0);
        vt.setVersion(version);
        this._em.persist((Object)vt);
        this._txCtx.commit();
    }

    public static ThreadLocal<ConfStoreDAOConnectionImpl> getThreadLocal() {
        return _connections;
    }
}

