/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.store;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.dao.jpa.store.ConfStoreDAO;
import org.apache.ode.dao.jpa.store.ProcessConfDaoImpl;
import org.apache.ode.dao.store.DeploymentUnitDAO;
import org.apache.ode.dao.store.ProcessConfDAO;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="STORE_DU")
public class DeploymentUnitDaoImpl
extends ConfStoreDAO
implements DeploymentUnitDAO {
    @OneToMany(targetEntity=ProcessConfDaoImpl.class, mappedBy="_du", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Collection<ProcessConfDaoImpl> _processes = new HashSet<ProcessConfDaoImpl>();
    @Basic
    @Column(name="DEPLOYER")
    private String _deployer;
    @Basic
    @Column(name="DEPLOYDT")
    private Date _deployDate;
    @Basic
    @Column(name="DIR")
    private String _dir;
    @Id
    @Column(name="NAME")
    private String _name;

    public Collection<? extends ProcessConfDAO> getProcesses() {
        return this._processes;
    }

    public void setProcesses(Collection<ProcessConfDaoImpl> processes) {
        this._processes = processes;
    }

    public String getDeployer() {
        return this._deployer;
    }

    public void setDeployer(String deployer) {
        this._deployer = deployer;
    }

    public Date getDeployDate() {
        return this._deployDate;
    }

    public void setDeployDate(Date deployDate) {
        this._deployDate = deployDate;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDeploymentUnitDir() {
        return this._dir;
    }

    public void setDeploymentUnitDir(String dir) {
        this._dir = dir;
    }

    @Override
    public void delete() {
        super.delete();
    }

    public ProcessConfDAO createProcess(QName pid, QName type, long version) {
        ProcessConfDaoImpl p = new ProcessConfDaoImpl();
        p.setPID(pid);
        p.setType(type);
        p.setDeploymentUnit(this);
        p.setState(ProcessState.ACTIVE);
        p.setVersion(version);
        this.getEM().persist((Object)p);
        this._processes.add(p);
        this.getEM().persist((Object)this);
        return p;
    }

    public ProcessConfDAO getProcess(final QName pid) {
        return (ProcessConfDAO)CollectionsX.find_if(this._processes, (MemberOfFunction)new MemberOfFunction<ProcessConfDAO>(){

            public boolean isMember(ProcessConfDAO o) {
                return o.getPID().equals(pid);
            }
        });
    }
}

