/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.scheduler.simple;

import java.text.SimpleDateFormat;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.scheduler.simple.Task;
import org.apache.ode.utils.GUID;

class Job
extends Task {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    String jobId;
    boolean transacted;
    Scheduler.JobDetails detail;
    boolean persisted = true;

    public Job(long when, boolean transacted, Scheduler.JobDetails jobDetail) {
        this(when, new GUID().toString(), transacted, jobDetail);
    }

    public Job(long when, String jobId, boolean transacted, Scheduler.JobDetails jobDetail) {
        super(when);
        this.jobId = jobId;
        this.detail = jobDetail;
        this.transacted = transacted;
    }

    public int hashCode() {
        return this.jobId.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Job && this.jobId.equals(((Job)obj).jobId);
    }

    public String toString() {
        SimpleDateFormat f = (SimpleDateFormat)DATE_FORMAT.clone();
        return "Job " + this.jobId + " time: " + f.format(this.schedDate) + " transacted: " + this.transacted + " persisted: " + this.persisted + " details: " + this.detail;
    }
}

