/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public class ProcessMutex {
    private int port;
    private ServerSocket ss = null;

    public ProcessMutex(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() throws InterruptedException {
        ProcessMutex processMutex = this;
        synchronized (processMutex) {
            if (this.ss != null) {
                throw new IllegalStateException("ProcessMutex: Bad mutex state exception.");
            }
            long startTime = System.currentTimeMillis();
            while (startTime + 15000L > System.currentTimeMillis()) {
                try {
                    this.ss = new ServerSocket();
                    this.ss.setReuseAddress(true);
                    this.ss.bind(new InetSocketAddress(this.port));
                    break;
                }
                catch (IOException ioe) {
                    Thread.sleep(2L);
                }
            }
            if (this.ss == null) {
                throw new InterruptedException("ProcessMutex: lock() timed out!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        ProcessMutex processMutex = this;
        synchronized (processMutex) {
            if (this.ss == null) {
                throw new IllegalStateException("ProcessMutex: Bad mutex state exception.");
            }
            try {
                this.ss.close();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("ProcessMutex: Error closing socket.");
            }
            finally {
                this.ss = null;
                this.notify();
            }
        }
    }
}

