/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class RelativeDateParser {
    private static final char YEAR_TEMPLATE_MODIFIER = 'y';
    private static final char MONTH_TEMPLATE_MODIFIER = 'M';
    private static final char WEEK_TEMPLATE_MODIFIER = 'w';
    private static final char DAY_TEMPLATE_MODIFIER = 'd';
    private static final char HOUR_TEMPLATE_MODIFIER = 'h';
    private static final char MINUTE_TEMPLATE_MODIFIER = 'm';
    private static final char SECOND_TEMPLATE_MODIFIER = 's';
    private static final char[] TEMPLATE_MODIFIERS_LIST = new char[]{'y', 'M', 'w', 'd', 'h', 'm', 's'};

    public static Date parseRelativeDate(String dateTemplate) throws ParseException {
        int[] agoValues = new int[TEMPLATE_MODIFIERS_LIST.length];
        int currentModifierPointer = 0;
        StringTokenizer tokens = new StringTokenizer(dateTemplate.trim());
        while (tokens.hasMoreTokens()) {
            int modValue;
            String token = tokens.nextToken();
            if (token.length() < 2 || token.length() > 5) {
                throw new ParseException("Invalid token length. Token: " + token, dateTemplate.indexOf(token));
            }
            try {
                modValue = Integer.parseInt(token.substring(0, token.length() - 1));
                if (modValue <= 0) {
                    throw new ParseException("Modifier value must be a positive number. Token: " + token, dateTemplate.indexOf(token));
                }
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Can't parse integer value. Token: " + token, dateTemplate.indexOf(token));
            }
            char mod = token.charAt(token.length() - 1);
            while (true) {
                if (currentModifierPointer >= TEMPLATE_MODIFIERS_LIST.length) {
                    throw new ParseException("Incorrect modifier at this position. Token: " + token, dateTemplate.indexOf(token) + token.length() - 1);
                }
                if (mod == TEMPLATE_MODIFIERS_LIST[currentModifierPointer]) break;
                ++currentModifierPointer;
            }
            if (agoValues[currentModifierPointer] != 0) {
                throw new ParseException("Dublicated modifier found. Token: " + token, dateTemplate.indexOf(token) + token.length() - 1);
            }
            agoValues[currentModifierPointer++] = modValue;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        for (int i = 0; i < agoValues.length; ++i) {
            if (agoValues[i] == 0) continue;
            int calendarField = RelativeDateParser.templateModifierIndexToCalendarField(i);
            calendar.add(calendarField, 0 - agoValues[i]);
        }
        return calendar.getTime();
    }

    private static int templateModifierIndexToCalendarField(int modifierIndex) throws IllegalArgumentException {
        switch (modifierIndex) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 13;
            }
        }
        throw new IllegalArgumentException("Invalid template modifier index: " + modifierIndex);
    }
}

