/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URITemplate {
    private static final Log log = LogFactory.getLog(URITemplate.class);
    public static final String EXPANSION_REGEX = "\\{[^\\}]+\\}";
    private static final Pattern PATTERN = Pattern.compile("\\{[^\\}]+\\}");

    public static Object[] parseExpansion(String expansion) {
        String[] var;
        String[] r;
        if (expansion.matches(EXPANSION_REGEX)) {
            expansion = expansion.substring(1, expansion.length() - 1);
        }
        if (expansion.contains("|")) {
            r = expansion.split("\\|", -1);
            r[0] = r[0].substring(1);
        } else {
            r = new String[]{null, null, expansion};
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        for (String s : var = r[2].split(",")) {
            if (s.contains("=")) {
                String[] a = s.split("=");
                vars.put(a[0], a[1]);
                continue;
            }
            vars.put(s, null);
        }
        return new Object[]{r[0], r[1], vars};
    }

    public static String expand(String uriTemplate, String ... nameValuePairs) throws URIException, UnsupportedOperationException {
        return URITemplate.expand(uriTemplate, URITemplate.toMap(nameValuePairs));
    }

    public static String expand(String uriTemplate, Map<String, String> nameValuePairs) throws URIException, UnsupportedOperationException {
        return URITemplate.expand(uriTemplate, nameValuePairs, false);
    }

    public static String expandLazily(String uriTemplate, Map<String, String> nameValuePairs) throws URIException, UnsupportedOperationException {
        return URITemplate.expand(uriTemplate, nameValuePairs, true);
    }

    public static String expandLazily(String uriTemplate, String ... nameValuePairs) throws URIException {
        return URITemplate.expandLazily(uriTemplate, URITemplate.toMap(nameValuePairs));
    }

    private static String expand(String uriTemplate, Map<String, String> nameValuePairs, boolean preserveUndefinedVar) throws URIException, UnsupportedOperationException {
        Matcher m = PATTERN.matcher(uriTemplate);
        StringBuilder sb = new StringBuilder(uriTemplate.length());
        int prevEnd = 0;
        while (m.find()) {
            sb.append(uriTemplate.substring(prevEnd, m.start()));
            prevEnd = m.end();
            String expansionPattern = uriTemplate.substring(m.start(), m.end());
            Object[] expansionInfo = URITemplate.parseExpansion(expansionPattern);
            String operationName = (String)expansionInfo[0];
            if (operationName != null) {
                String msg = "Operation not supported [" + operationName + "]. This expansion pattern [" + expansionPattern + "] is not valid.";
                if (log.isWarnEnabled()) {
                    log.warn((Object)msg);
                }
                throw new UnsupportedOperationException(msg);
            }
            sb.append(URITemplate.varSubstitution(expansionPattern, expansionInfo, nameValuePairs, preserveUndefinedVar));
        }
        if (sb.length() == 0) {
            return uriTemplate;
        }
        sb.append(uriTemplate.substring(prevEnd, uriTemplate.length()));
        return sb.toString();
    }

    public static String varSubstitution(String expansionPattern, Object[] expansionInfo, Map<String, String> nameValuePairs) throws URIException {
        return URITemplate.varSubstitution(expansionPattern, expansionInfo, nameValuePairs, false);
    }

    public static String varSubstitution(String expansionPattern, Object[] expansionInfo, Map<String, String> nameValuePairs, boolean preserveUndefinedVar) throws URIException {
        String res;
        Map vars = (Map)expansionInfo[2];
        Map.Entry e = vars.entrySet().iterator().next();
        String var = (String)e.getKey();
        String defaultValue = (String)e.getValue();
        boolean hasDefaultValue = defaultValue != null;
        boolean varDefined = nameValuePairs.containsKey(var);
        String providedValue = nameValuePairs.get(var);
        boolean escapingNeeded = true;
        if (varDefined) {
            res = providedValue == null && !hasDefaultValue ? "" : (providedValue != null ? providedValue : defaultValue);
        } else if (hasDefaultValue) {
            res = defaultValue;
        } else if (preserveUndefinedVar) {
            res = expansionPattern;
            escapingNeeded = false;
        } else {
            res = "";
        }
        return escapingNeeded ? URIUtil.encodeWithinQuery((String)res) : res;
    }

    private static Map<String, String> toMap(String ... nameValuePairs) {
        if (nameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of elements is expected.");
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            m.put(nameValuePairs[i], nameValuePairs[i + 1]);
        }
        return m;
    }
}

