/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.sax;

import java.io.PrintStream;
import org.apache.ode.utils.sax.IgnoreAllErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrintErrorHandler
implements ErrorHandler {
    private ErrorHandler _child;
    private PrintStream _out;

    public PrintErrorHandler(ErrorHandler eh, PrintStream ps) {
        this._child = eh;
        this._out = ps;
    }

    public PrintErrorHandler(PrintStream pw) {
        this(new IgnoreAllErrorHandler(), pw);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this._out.println(this.formatMessage(exception));
        this._child.warning(exception);
    }

    public void error(SAXParseException exception) throws SAXException {
        this._out.println(this.formatMessage(exception));
        this._child.error(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this._out.println(this.formatMessage(exception));
        this._child.fatalError(exception);
    }

    private String formatMessage(SAXParseException spe) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(spe.getSystemId());
        sb.append(':');
        sb.append(spe.getLineNumber());
        sb.append(':');
        sb.append(spe.getColumnNumber());
        sb.append("] ");
        sb.append(spe.getMessage());
        return sb.toString();
    }
}

