/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.engine.ode;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.evt.DebugBpelEventListener;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactory;
import org.apache.ode.bpel.engine.BpelManagementFacadeImpl;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.CountLRUDehydrationPolicy;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.cron.CronScheduler;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.extvar.jdbc.JdbcExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.scheduler.simple.DatabaseDelegate;
import org.apache.ode.scheduler.simple.JdbcDelegate;
import org.apache.ode.scheduler.simple.SimpleScheduler;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.store.RiftSawProcessStore;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.jboss.soa.bpel.runtime.engine.BPELEngine;
import org.jboss.soa.bpel.runtime.engine.IntegrationLayer;
import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;
import org.jboss.soa.bpel.runtime.engine.ode.EndpointReferenceContextImpl;
import org.jboss.soa.bpel.runtime.engine.ode.ExecutionEnvironment;
import org.jboss.soa.bpel.runtime.engine.ode.JAXWSBindingContext;
import org.jboss.soa.bpel.runtime.engine.ode.MessageExchangeContextImpl;
import org.w3c.dom.Node;

public class BPELEngineImpl
implements BPELEngine,
ExecutionEnvironment {
    protected final Log __log = LogFactory.getLog(this.getClass());
    protected final Log __logTx = LogFactory.getLog((String)"org.apache.ode.tx");
    protected BpelServerImpl _bpelServer;
    public ProcessStoreImpl _store;
    protected OdeConfigProperties _odeConfig;
    protected TransactionManager _txMgr;
    protected BpelDAOConnectionFactory _daoCF;
    protected Scheduler _scheduler;
    protected Database _db;
    protected ExecutorService _executorService;
    protected CronScheduler _cronScheduler;
    private List<IntegrationLayer> m_integrationLayers = new Vector<IntegrationLayer>();

    public Object getManagementInterface() {
        return new BpelManagementFacadeImpl((BpelServer)this._bpelServer, (ProcessStore)this._store);
    }

    public void invoke(InvocationAdapter invocationAdapter) throws Exception {
        boolean success = true;
        MyRoleMessageExchange odeMex = null;
        Future responseFuture = null;
        try {
            this._txMgr.begin();
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)"Starting transaction.");
            }
            if ((odeMex = this.createMessageExchange(invocationAdapter)).getOperation() != null) {
                Message odeRequest = odeMex.createMessage(odeMex.getOperation().getInput().getMessage().getQName());
                invocationAdapter.parseRequest(odeMex, odeRequest);
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Invoking ODE using MEX " + odeMex));
                    this.__log.debug((Object)("Message content:  " + DOMUtils.domToString((Node)odeRequest.getMessage())));
                }
                responseFuture = odeMex.invoke(odeRequest);
                this.__log.debug((Object)("Commiting ODE MEX " + odeMex));
                try {
                    if (this.__log.isDebugEnabled()) {
                        this.__log.debug((Object)"Commiting transaction.");
                    }
                    this._txMgr.commit();
                }
                catch (Exception e) {
                    this.__log.error((Object)"Commit failed", (Throwable)e);
                    success = false;
                }
            } else {
                success = false;
            }
        }
        catch (Exception e) {
            this.__log.error((Object)"Exception occured while invoking ODE", (Throwable)e);
            success = false;
            String mesg = e.getMessage();
            if (mesg == null) {
                mesg = "An exception occured while invoking ODE.";
            }
            throw new Exception(mesg, e);
        }
        finally {
            if (!success) {
                if (odeMex != null) {
                    odeMex.release(success);
                }
                try {
                    this._txMgr.rollback();
                }
                catch (Exception e) {
                    throw new Exception("Rollback failed", e);
                }
            }
        }
        if (odeMex.getOperation().getOutput() != null) {
            try {
                responseFuture.get(this.resolveTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                String errorMsg = "Timeout or execution error when waiting for response to MEX " + odeMex + " " + e.toString();
                this.__log.error((Object)errorMsg, (Throwable)e);
                throw new Exception(errorMsg);
            }
            this.__log.debug((Object)("Handling response for MEX " + odeMex));
            boolean commit = false;
            try {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)"Starting transaction.");
                }
                this._txMgr.begin();
            }
            catch (Exception ex) {
                throw new Exception("Error starting transaction!", ex);
            }
            try {
                odeMex = (MyRoleMessageExchange)this._bpelServer.getEngine().getMessageExchange(odeMex.getMessageExchangeId());
                this.onResponse(odeMex, invocationAdapter);
                this.__log.debug((Object)("Returning: " + invocationAdapter.getInvocationResult()));
                commit = true;
            }
            catch (Exception e) {
                this.__log.error((Object)("Error processing response for MEX " + odeMex), (Throwable)e);
                throw new Exception("An exception occured when invoking ODE.", e);
            }
            finally {
                odeMex.release(commit);
                if (commit) {
                    try {
                        if (this.__log.isDebugEnabled()) {
                            this.__log.debug((Object)"Comitting transaction.");
                        }
                        this._txMgr.commit();
                    }
                    catch (Exception e) {
                        throw new Exception("Commit failed!", e);
                    }
                }
                try {
                    this._txMgr.rollback();
                }
                catch (Exception ex) {
                    throw new Exception("Rollback failed!", ex);
                }
            }
            if (!success) {
                throw new Exception("Message was either unroutable or timed out!");
            }
        } else {
            odeMex.release(true);
        }
    }

    private MyRoleMessageExchange createMessageExchange(InvocationAdapter adapter) {
        String messageId = new GUID().toString();
        MyRoleMessageExchange odeMex = this._bpelServer.getEngine().createMessageExchange(messageId, adapter.getServiceName(), adapter.getOperationName());
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("ODE routed to operation " + odeMex.getOperation() + " from service " + adapter.getServiceName()));
        }
        return odeMex;
    }

    private void onResponse(MyRoleMessageExchange mex, InvocationAdapter invocationAdapter) throws Exception {
        Object ret = null;
        switch (mex.getStatus()) {
            case FAULT: {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Fault response message: " + mex.getFault()));
                }
                invocationAdapter.createFault(mex);
                break;
            }
            case ASYNC: 
            case RESPONSE: {
                invocationAdapter.createResponse(mex);
                if (!this.__log.isDebugEnabled()) break;
                this.__log.debug((Object)("Response message " + ret));
                break;
            }
            case FAILURE: {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Failure response message: " + mex.getFault()));
                }
                this.__log.error((Object)("Failure details: " + mex.getFaultResponse()));
                throw new Exception("Failure response message: " + mex.getFault() + " : " + mex.getFaultExplanation());
            }
            default: {
                throw new Exception("Received ODE message exchange in unexpected state: " + mex.getStatus());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIntegrationLayer(IntegrationLayer il) {
        List<IntegrationLayer> list = this.m_integrationLayers;
        synchronized (list) {
            this.m_integrationLayers.add(il);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIntegrationLayer(IntegrationLayer il) {
        List<IntegrationLayer> list = this.m_integrationLayers;
        synchronized (list) {
            this.m_integrationLayers.remove(il);
        }
    }

    private long resolveTimeout() {
        return 120000L;
    }

    public void init() throws Exception {
        Properties props = new Properties();
        try {
            InputStream is = BPELEngineImpl.class.getClassLoader().getResourceAsStream("bpel.properties");
            props.load(is);
        }
        catch (Exception e) {
            this.__log.error((Object)"Failed to load properties", (Throwable)e);
        }
        this.__log.debug((Object)("ODE PROPS=" + props));
        this._odeConfig = new OdeConfigProperties(props, "bpel.");
        this.__log.debug((Object)"Initializing transaction manager");
        this.initTxMgr();
        this.__log.debug((Object)"Creating data source.");
        this.initDataSource();
        this.__log.debug((Object)"Starting DAO.");
        this.initDAO();
        EndpointReferenceContextImpl eprContext = new EndpointReferenceContextImpl(this);
        this.__log.debug((Object)"Initializing BPEL process store.");
        this.initProcessStore(eprContext);
        this.__log.debug((Object)"Initializing BPEL server.");
        this.initBpelServer(eprContext);
        this._store.loadAll();
        this.registerEventListeners();
        this.registerMexInterceptors();
        this.registerExternalVariableModules();
        try {
            this._bpelServer.start();
        }
        catch (Exception ex) {
            String errmsg = "SERVER START FAILED";
            this.__log.error((Object)errmsg, (Throwable)ex);
        }
        this.__log.debug((Object)"Starting scheduler");
        this._scheduler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this._bpelServer != null) {
                try {
                    this.__log.debug((Object)"shutting down BPEL server.");
                    this._bpelServer.shutdown();
                    this._bpelServer = null;
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"Error stopping services.", ex);
                }
            }
            if (this._cronScheduler != null) {
                try {
                    this.__log.debug((Object)"shutting down cron scheduler.");
                    this._cronScheduler.shutdown();
                    this._cronScheduler = null;
                }
                catch (Exception ex) {
                    this.__log.debug((Object)"Cron scheduler couldn't be shutdown.", (Throwable)ex);
                }
            }
            if (this._scheduler != null) {
                try {
                    this.__log.debug((Object)"shutting down scheduler.");
                    this._scheduler.shutdown();
                    this._scheduler = null;
                }
                catch (Exception ex) {
                    this.__log.debug((Object)"Scheduler couldn't be shutdown.", (Throwable)ex);
                }
            }
            if (this._store != null) {
                try {
                    this._store.shutdown();
                    this._store = null;
                }
                catch (Throwable t) {
                    this.__log.debug((Object)"Store could not be shutdown.", t);
                }
            }
            if (this._daoCF != null) {
                try {
                    this._daoCF.shutdown();
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"DOA shutdown failed.", ex);
                }
                finally {
                    this._daoCF = null;
                }
            }
            if (this._db != null) {
                try {
                    this._db.shutdown();
                }
                catch (Throwable ex) {
                    this.__log.debug((Object)"DB shutdown failed.", ex);
                }
                finally {
                    this._db = null;
                }
            }
            if (this._txMgr != null) {
                this.__log.debug((Object)"shutting down transaction manager.");
                this._txMgr = null;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void initDataSource() throws Exception {
        this._db = new Database(this._odeConfig);
        this._db.setTransactionManager(this._txMgr);
        try {
            this._db.start();
        }
        catch (Exception ex) {
            String errmsg = "FAILED TO INITIALISE DATA SOURCE";
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new Exception(errmsg, ex);
        }
    }

    private void initTxMgr() throws Exception {
        String txFactoryName = this._odeConfig.getTxFactoryClass();
        this.__log.debug((Object)("Initializing transaction manager using " + txFactoryName));
        try {
            Class<?> txFactClass = this.getClass().getClassLoader().loadClass(txFactoryName);
            Object txFact = txFactClass.newInstance();
            this._txMgr = (TransactionManager)txFactClass.getMethod("getTransactionManager", null).invoke(txFact, new Object[0]);
            if (this.__logTx.isDebugEnabled() && System.getProperty("ode.debug.tx") != null) {
                this._txMgr = new DebugTxMgr(this._txMgr);
            }
        }
        catch (Exception e) {
            this.__log.fatal((Object)("Couldn't initialize a transaction manager with factory: " + txFactoryName), (Throwable)e);
            throw new Exception("Couldn't initialize a transaction manager with factory: " + txFactoryName, e);
        }
    }

    protected void initDAO() throws Exception {
        this.__log.debug((Object)("USING DAO: " + this._odeConfig.getDAOConnectionFactory()));
        try {
            this._daoCF = this._db.createDaoCF();
        }
        catch (Exception ex) {
            String errmsg = "DAO INSTANTIATION FAILED: " + this._odeConfig.getDAOConnectionFactory();
            this.__log.error((Object)errmsg, (Throwable)ex);
            throw new Exception(errmsg, ex);
        }
    }

    protected void initProcessStore(EndpointReferenceContext eprContext) {
        this._store = this.createProcessStore(eprContext, this._db.getDataSource());
        this._store.registerListener((ProcessStoreListener)new ProcessStoreListenerImpl());
    }

    protected ProcessStoreImpl createProcessStore(EndpointReferenceContext eprContext, DataSource ds) {
        return new RiftSawProcessStore(eprContext, ds, this._odeConfig.getDAOConnectionFactory(), this._odeConfig, false);
    }

    protected Scheduler createScheduler() {
        SimpleScheduler scheduler = new SimpleScheduler(new GUID().toString(), (DatabaseDelegate)new JdbcDelegate(this._db.getDataSource()), this._odeConfig.getProperties());
        scheduler.setExecutorService(this._executorService);
        scheduler.setTransactionManager(this._txMgr);
        return scheduler;
    }

    private void initBpelServer(EndpointReferenceContextImpl eprContext) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)"ODE initializing");
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            int threadNumber = 0;

            public Thread newThread(Runnable r) {
                ++this.threadNumber;
                Thread t = new Thread(r, "ODEServer-" + this.threadNumber);
                t.setDaemon(true);
                return t;
            }
        };
        this._executorService = this._odeConfig.getThreadPoolMaxSize() == 0 ? Executors.newCachedThreadPool(threadFactory) : Executors.newFixedThreadPool(this._odeConfig.getThreadPoolMaxSize(), threadFactory);
        this._bpelServer = new BpelServerImpl();
        this._scheduler = this.createScheduler();
        this._scheduler.setJobProcessor((Scheduler.JobProcessor)this._bpelServer);
        BpelServerImpl.PolledRunnableProcessor polledRunnableProcessor = new BpelServerImpl.PolledRunnableProcessor();
        polledRunnableProcessor.setPolledRunnableExecutorService(this._executorService);
        polledRunnableProcessor.setContexts(this._bpelServer.getContexts());
        this._scheduler.setPolledRunnableProcesser((Scheduler.JobProcessor)polledRunnableProcessor);
        this._cronScheduler = new CronScheduler();
        this._cronScheduler.setScheduledTaskExec(this._executorService);
        this._cronScheduler.setContexts(this._bpelServer.getContexts());
        this._bpelServer.setCronScheduler(this._cronScheduler);
        this._bpelServer.setDaoConnectionFactory(this._daoCF);
        this._bpelServer.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl(this._scheduler, this._odeConfig.getInMemMexTtl()));
        this._bpelServer.setEndpointReferenceContext((EndpointReferenceContext)eprContext);
        this._bpelServer.setMessageExchangeContext((MessageExchangeContext)new MessageExchangeContextImpl(this));
        this._bpelServer.setBindingContext((BindingContext)new JAXWSBindingContext(this));
        this._bpelServer.setScheduler(this._scheduler);
        if (this._odeConfig.isDehydrationEnabled()) {
            CountLRUDehydrationPolicy dehy = new CountLRUDehydrationPolicy();
            dehy.setProcessMaxAge(this._odeConfig.getDehydrationMaximumAge());
            dehy.setProcessMaxCount(this._odeConfig.getDehydrationMaximumCount());
            this._bpelServer.setDehydrationPolicy((DehydrationPolicy)dehy);
        }
        this._bpelServer.setConfigProperties(this._odeConfig.getProperties());
        this._bpelServer.init();
        this._bpelServer.setInstanceThrottledMaximumCount(this._odeConfig.getInstanceThrottledMaximumCount());
        this._bpelServer.setProcessThrottledMaximumCount(this._odeConfig.getProcessThrottledMaximumCount());
        this._bpelServer.setProcessThrottledMaximumSize(this._odeConfig.getProcessThrottledMaximumSize());
        this._bpelServer.setHydrationLazy(this._odeConfig.isHydrationLazy());
        this._bpelServer.setHydrationLazyMinimumSize(this._odeConfig.getHydrationLazyMinimumSize());
    }

    private void registerEventListeners() {
        this._bpelServer.registerBpelEventListener((BpelEventListener)new DebugBpelEventListener());
        String listenersStr = this._odeConfig.getEventListeners();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String listenerCN = tokenizer.nextToken();
                try {
                    this._bpelServer.registerBpelEventListener((BpelEventListener)Class.forName(listenerCN).newInstance());
                    this.__log.debug((Object)("REGISTERED EVENT LISTENER: " + listenerCN));
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the event listener " + listenerCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerMexInterceptors() {
        String listenersStr = this._odeConfig.getMessageExchangeInterceptors();
        if (listenersStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(listenersStr, ",;");
            while (tokenizer.hasMoreTokens()) {
                String interceptorCN = tokenizer.nextToken();
                try {
                    this._bpelServer.registerMessageExchangeInterceptor((MessageExchangeInterceptor)Class.forName(interceptorCN).newInstance());
                    this.__log.debug((Object)("MESSAGE EXCHANGE INTERCEPTOR REGISTERED: " + interceptorCN));
                }
                catch (Exception e) {
                    this.__log.warn((Object)("Couldn't register the event listener " + interceptorCN + ", the class couldn't be " + "loaded properly: " + e));
                }
            }
        }
    }

    private void registerExternalVariableModules() {
        JdbcExternalVariableModule jdbcext = new JdbcExternalVariableModule();
        jdbcext.registerDataSource("ode", this._db.getDataSource());
        this._bpelServer.registerExternalVariableEngine((ExternalVariableModule)jdbcext);
    }

    private void handleEvent(ProcessStoreEvent pse) {
        this.__log.debug((Object)("Process store event: " + pse));
        ProcessConf pconf = this._store.getProcessConfiguration(pse.pid);
        switch (pse.type) {
            case DEPLOYED: {
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            case ACTVIATED: {
                this._bpelServer.unregister(pse.pid);
                if (pconf != null) {
                    this._bpelServer.register(pconf);
                    break;
                }
                this.__log.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                break;
            }
            case RETIRED: {
                boolean instantiated = this._bpelServer.hasActiveInstances(pse.pid);
                this._bpelServer.unregister(pse.pid);
                if (instantiated) {
                    if (pconf != null) {
                        this._bpelServer.register(pconf);
                        break;
                    }
                    this.__log.debug((Object)("slighly odd: recevied event " + pse + " for process not in store!"));
                    break;
                }
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            case DISABLED: 
            case UNDEPLOYED: {
                this._bpelServer.unregister(pse.pid);
                if (pconf == null) break;
                this._bpelServer.cleanupProcess(pconf);
                break;
            }
            default: {
                this.__log.debug((Object)("Ignoring store event: " + pse));
            }
        }
        if (pconf != null) {
            if (pse.type == ProcessStoreEvent.Type.UNDEPLOYED) {
                this.__log.debug((Object)("Cancelling all cron scheduled jobs on store event: " + pse));
                this._bpelServer.getContexts().cronScheduler.cancelProcessCronJobs(pse.pid, true);
            }
            this.__log.debug((Object)("(Re)scheduling cron scheduled jobs on store event: " + pse));
            if (pse.type != ProcessStoreEvent.Type.UNDEPLOYED) {
                this._bpelServer.getContexts().cronScheduler.scheduleProcessCronJobs(pse.pid, pconf);
            }
        }
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public CronScheduler getCronScheduler() {
        return this._cronScheduler;
    }

    public OdeConfigProperties getOdeConfig() {
        return this._odeConfig;
    }

    private class DebugTx
    implements Transaction {
        private Transaction _tx;

        public DebugTx(Transaction tx) {
            this._tx = tx;
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Tx commit");
            this._tx.commit();
        }

        public boolean delistResource(XAResource xaResource, int i) throws IllegalStateException, SystemException {
            return this._tx.delistResource(xaResource, i);
        }

        public boolean enlistResource(XAResource xaResource) throws IllegalStateException, RollbackException, SystemException {
            return this._tx.enlistResource(xaResource);
        }

        public int getStatus() throws SystemException {
            return this._tx.getStatus();
        }

        public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, RollbackException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)("Synchronization registration on " + synchronization.getClass().getName()));
            this._tx.registerSynchronization(synchronization);
        }

        public void rollback() throws IllegalStateException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Tx rollback");
            this._tx.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Tx set rollback");
            this._tx.setRollbackOnly();
        }
    }

    private class DebugTxMgr
    implements TransactionManager {
        private TransactionManager _tm;

        public DebugTxMgr(TransactionManager tm) {
            this._tm = tm;
        }

        public void begin() throws NotSupportedException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm begin");
            this._tm.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm commit");
            for (StackTraceElement traceElement : Thread.currentThread().getStackTrace()) {
                BPELEngineImpl.this.__logTx.debug((Object)traceElement.toString());
            }
            this._tm.commit();
        }

        public int getStatus() throws SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm status");
            return this._tm.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            Transaction tx = this._tm.getTransaction();
            BPELEngineImpl.this.__logTx.debug((Object)("Txm get tx " + tx));
            return tx == null ? null : new DebugTx(tx);
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm resume");
            this._tm.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm rollback");
            this._tm.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm set rollback");
            this._tm.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)("Txm set tiemout " + i));
            this._tm.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            BPELEngineImpl.this.__logTx.debug((Object)"Txm suspend");
            return this._tm.suspend();
        }
    }

    private class ProcessStoreListenerImpl
    implements ProcessStoreListener {
        private ProcessStoreListenerImpl() {
        }

        public void onProcessStoreEvent(ProcessStoreEvent event) {
            BPELEngineImpl.this.handleEvent(event);
        }
    }
}

