/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.engine.ode;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.UUID;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.jboss.soa.bpel.runtime.engine.ode.BPELEngineImpl;
import org.jboss.soa.bpel.runtime.engine.ode.PartnerRoleChannelImpl;
import org.jboss.soa.bpel.runtime.ws.EndpointManager;
import org.jboss.soa.bpel.runtime.ws.EndpointMetaData;
import org.jboss.soa.bpel.runtime.ws.WSDLParser;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;
import org.jboss.soa.bpel.runtime.ws.WebServiceClient;

public class JAXWSBindingContext
implements BindingContext {
    protected final Log log = LogFactory.getLog(this.getClass());
    private BPELEngineImpl engine;
    private EndpointManager endpointManager;

    public JAXWSBindingContext(BPELEngineImpl server) {
        this.engine = server;
        this.endpointManager = new EndpointManager(this.engine);
    }

    public EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
        this.log.info((Object)("*** ACTIVATING MY ROLE ENDPOINT: " + myRoleEndpoint));
        EndpointReference ref = this.endpointManager.maintains(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
        if (ref != null) {
            this.log.warn((Object)("Endpoint does already exist: " + myRoleEndpoint.serviceName + "/" + myRoleEndpoint.portName));
        } else {
            WSDLReference wsdlReference = this.createWSDLReference(processId, myRoleEndpoint);
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String endpointId = UUID.randomUUID().toString();
                EndpointMetaData endpointMD = new EndpointMetaData(myRoleEndpoint.serviceName, myRoleEndpoint.portName, processId, endpointId);
                ref = this.endpointManager.createEndpoint(endpointMD, wsdlReference, classLoader);
            }
            catch (Throwable e) {
                throw new ContextException("Failed to activate endpoint", e);
            }
        }
        return ref;
    }

    private WSDLReference createWSDLReference(QName processId, Endpoint myRoleEndpoint) {
        File targetWSDLFile = this.findWSDLFile(processId, myRoleEndpoint);
        Definition wsdlDefinition = this.getWSDLDefinition(processId, myRoleEndpoint.serviceName);
        return new WSDLReference(wsdlDefinition, targetWSDLFile);
    }

    private File findWSDLFile(QName processId, Endpoint myRoleEndpoint) {
        ProcessConf pconf = this.engine._store.getProcessConfiguration(processId);
        List files = pconf.getFiles();
        File targetWsdlFile = null;
        for (File f : files) {
            if (!f.getName().endsWith(".wsdl")) continue;
            try {
                WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
                Definition def = wsdlReader.readWSDL(f.toURL().toExternalForm());
                URL url = new WSDLParser(def).getServiceLocationURL(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
                if (url == null) continue;
                targetWsdlFile = f;
                this.log.debug((Object)("Matching " + processId + " to WSDL file " + targetWsdlFile));
                break;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (null == targetWsdlFile) {
            throw new ContextException("Unable to find target WSDL file for " + myRoleEndpoint);
        }
        return targetWsdlFile;
    }

    public void deactivateMyRoleEndpoint(Endpoint myRoleEndpoint) {
        this.log.info((Object)("*** DEACTIVATING MY ROLE ENDPOINT: " + myRoleEndpoint));
        EndpointReference ref = this.endpointManager.maintains(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
        if (null == ref) {
            this.log.warn((Object)("Endpoint doesn't exist (Has it been undeployed before?): " + myRoleEndpoint.serviceName + "/" + myRoleEndpoint.portName));
        } else {
            try {
                this.endpointManager.removeEndpoint(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
            }
            catch (Throwable e) {
                throw new ContextException("Failed to deactivate endpoint", e);
            }
        }
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType, Endpoint initialPartnerEndpoint) {
        WSDLReference wsdlReference = this.createWSDLReference(processId, initialPartnerEndpoint);
        String endpointId = UUID.randomUUID().toString();
        EndpointMetaData endpointMD = new EndpointMetaData(initialPartnerEndpoint.serviceName, initialPartnerEndpoint.portName, processId, endpointId);
        try {
            WebServiceClient channel = this.endpointManager.createClient(endpointMD, wsdlReference);
            return new PartnerRoleChannelImpl(channel);
        }
        catch (Throwable t) {
            throw new ContextException("Failed to create partner channel", t);
        }
    }

    private Definition getWSDLDefinition(QName processId, QName serviceName) {
        ProcessConf pconf = this.engine._store.getProcessConfiguration(processId);
        Definition wsdl = pconf.getDefinitionForService(serviceName);
        if (wsdl == null) {
            throw new ContextException("Unable to access WSDL definition to activate MyRole endpoint for service " + serviceName + " on process " + processId);
        }
        return wsdl;
    }

    public long calculateSizeofService(EndpointReference arg0) {
        return 0L;
    }
}

