/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.engine.ode;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.annotations.AnnotationProcessor;
import org.apache.juddi.v3.client.config.TokenResolver;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.transport.TransportException;
import org.jboss.soa.bpel.runtime.ws.EndpointMetaData;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class UDDIRegistration
extends AnnotationProcessor {
    protected static final Log log = LogFactory.getLog(UDDIRegistration.class);
    public static final String BPEL_CLERK = "BPELClerk";
    public static final String DEFAULT_SERVICE_KEY_FORMAT = "uddi:${keyDomain}:bpel-services-";
    public static final String DEFAULT_BINDING_KEY_FORMAT = "uddi:${keyDomain}:bindings-";
    public static final String LANG = "lang";
    public static final String SERVICE_DESCRIPTION = "serviceDescription";
    public static final String SERVICE_CATEGORY_BAG = "serviceCategoryBag";
    public static final String BINDING_DESCRIPTION = "bindingDescription";
    public static final String BINDING_CATEGORY_BAG = "bindingCategoryBag";
    public static final String BINDING_TMODEL_KEYS = "bindingTModelKeys";
    public static final String SERVICE_KEY_FORMAT = "serviceKeyFormat";
    public static final String BINDING_KEY_FORMAT = "bindingKeyFormat";

    public void registerEPR(EndpointMetaData metaData, WSDLReference wsdlRef) {
        block7: {
            boolean selfRegister = false;
            try {
                selfRegister = UDDIClerkManager.getClientConfig().isRegisterOnStartup();
                if (!selfRegister) break block7;
                Map clerks = UDDIClerkManager.getClientConfig().getUDDIClerks();
                UDDIClerk bpelClerk = (UDDIClerk)clerks.get(BPEL_CLERK);
                if (bpelClerk != null) {
                    try {
                        BusinessService service = this.createBusinessService(bpelClerk, metaData, wsdlRef);
                        bpelClerk.register(service, bpelClerk.getUDDINode().getApiNode());
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to register service " + metaData.getServiceName() + " ." + e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable t) {
                        log.error((Object)("Unable to register service " + metaData.getServiceName() + " ." + t.getMessage()), t);
                    }
                    break block7;
                }
                throw new ConfigurationException("Could not find UDDI Clerk named BPELClerk");
            }
            catch (ConfigurationException ce) {
                if (selfRegister) {
                    log.error((Object)ce.getMessage(), (Throwable)ce);
                }
                log.info((Object)ce.getMessage());
            }
        }
    }

    public void unRegisterEPR(QName service, String port) {
        block10: {
            boolean selfRegister = false;
            try {
                selfRegister = UDDIClerkManager.getClientConfig().isRegisterOnStartup();
                if (!selfRegister) break block10;
                Map clerks = UDDIClerkManager.getClientConfig().getUDDIClerks();
                UDDIClerk bpelClerk = (UDDIClerk)clerks.get(BPEL_CLERK);
                String bindingName = service.getLocalPart() + "-" + port;
                if (bpelClerk != null) {
                    try {
                        Properties properties = bpelClerk.getUDDINode().getProperties();
                        String bindingKey = TokenResolver.replaceTokens((String)(DEFAULT_BINDING_KEY_FORMAT + bindingName), (Properties)properties);
                        if (properties.containsKey(BINDING_KEY_FORMAT)) {
                            bindingKey = TokenResolver.replaceTokens((String)((String)properties.get(BINDING_KEY_FORMAT) + bindingName), (Properties)properties);
                        }
                        bindingKey = bindingKey.toLowerCase();
                        BindingTemplate binding = null;
                        try {
                            binding = bpelClerk.findServiceBinding(bindingKey, bpelClerk.getUDDINode().getApiNode());
                            BusinessService businessService = bpelClerk.findService(binding.getServiceKey(), bpelClerk.getUDDINode().getApiNode());
                            bpelClerk.unRegister(businessService, bpelClerk.getUDDINode().getApiNode());
                            break block10;
                        }
                        catch (Exception e) {
                            log.warn((Object)("Could not find BindingTemplate with key " + bindingKey + " for unRegistration."));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to unRegister EPR " + bindingName + " ." + e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable t) {
                        log.error((Object)("Unable to unRegister EPR " + bindingName + " ." + t.getMessage()), t);
                    }
                    break block10;
                }
                throw new ConfigurationException("Could not find UDDI Clerk named BPELClerk");
            }
            catch (ConfigurationException ce) {
                if (selfRegister) {
                    log.error((Object)ce.getMessage(), (Throwable)ce);
                }
                log.info((Object)ce.getMessage());
            }
        }
    }

    private BusinessService createBusinessService(UDDIClerk clerk, EndpointMetaData metaData, WSDLReference wsdlRef) throws DispositionReportFaultMessage, RemoteException, ConfigurationException, TransportException {
        BusinessService service;
        block6: {
            Properties properties = clerk.getUDDINode().getProperties();
            String serviceKey = TokenResolver.replaceTokens((String)(DEFAULT_SERVICE_KEY_FORMAT + metaData.getServiceName().getLocalPart()), (Properties)properties);
            if (properties.containsKey(SERVICE_KEY_FORMAT)) {
                serviceKey = TokenResolver.replaceTokens((String)((String)properties.get(SERVICE_KEY_FORMAT) + metaData.getServiceName()), (Properties)properties);
            }
            service = null;
            try {
                service = clerk.findService(serviceKey, clerk.getUDDINode().getApiNode());
                log.debug((Object)("Service " + metaData.getServiceName() + " already present in the UDDI Registry"));
            }
            catch (Exception e) {
                log.debug((Object)("Constructing Service UDDI Information for " + metaData.getServiceName()));
                service = new BusinessService();
                service.setBusinessKey(TokenResolver.replaceTokens((String)"uddi:${keyDomain}:${businessKey}", (Properties)properties));
                service.setServiceKey(serviceKey);
                if (properties.containsKey(SERVICE_DESCRIPTION)) {
                    Description description = new Description();
                    String lang = "en";
                    if (properties.containsKey(LANG)) {
                        lang = properties.getProperty(LANG);
                    }
                    description.setLang(lang);
                    description.setValue(properties.getProperty(SERVICE_DESCRIPTION));
                    Name serviceName = new Name();
                    serviceName.setLang(lang);
                    serviceName.setValue(metaData.getServiceName().getLocalPart());
                    service.getName().add(serviceName);
                    service.getDescription().add(description);
                }
                if (!properties.containsKey(SERVICE_CATEGORY_BAG)) break block6;
                String defaultCategoryBag = properties.getProperty(SERVICE_CATEGORY_BAG);
                log.info((Object)("Adding categoryBag: " + defaultCategoryBag));
                CategoryBag categoryBag = this.parseCategoryBag(defaultCategoryBag);
                service.setCategoryBag(categoryBag);
            }
        }
        BindingTemplate binding = this.createBindingTemplate(clerk, metaData, wsdlRef);
        if (service.getBindingTemplates() == null) {
            BindingTemplates bindingTemplates = new BindingTemplates();
            service.setBindingTemplates(bindingTemplates);
        }
        service.getBindingTemplates().getBindingTemplate().add(binding);
        return service;
    }

    private BindingTemplate createBindingTemplate(UDDIClerk clerk, EndpointMetaData metaData, WSDLReference wsdlRef) {
        String defaultCategoryBag;
        Properties properties = clerk.getUDDINode().getProperties();
        BindingTemplate bindingTemplate = new BindingTemplate();
        String bindingKey = TokenResolver.replaceTokens((String)(DEFAULT_BINDING_KEY_FORMAT + metaData.getServiceName().getLocalPart() + "-" + metaData.getPortName()), (Properties)properties);
        if (properties.containsKey(BINDING_KEY_FORMAT)) {
            bindingKey = TokenResolver.replaceTokens((String)((String)properties.get(BINDING_KEY_FORMAT) + metaData.getServiceName().getLocalPart() + "-" + metaData.getPortName()), (Properties)properties);
        }
        bindingTemplate.setBindingKey(bindingKey);
        String lang = "en";
        if (properties.containsKey(LANG)) {
            lang = properties.getProperty(LANG);
        }
        if (properties.containsKey(BINDING_DESCRIPTION)) {
            Description bindingDescription = new Description();
            bindingDescription.setLang(lang);
            bindingDescription.setValue(properties.getProperty(BINDING_DESCRIPTION));
            bindingTemplate.getDescription().add(bindingDescription);
        }
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
        accessPoint.setValue(wsdlRef.getWsdlFileURL().toString());
        bindingTemplate.setAccessPoint(accessPoint);
        String defaultTModelKeys = properties.getProperty("tModelKeys");
        if (defaultTModelKeys != null && !"".equals(defaultTModelKeys)) {
            String[] tModelKeys;
            for (String tModelKey : tModelKeys = defaultTModelKeys.split(",")) {
                TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
                instanceInfo.setTModelKey(tModelKey);
                if (bindingTemplate.getTModelInstanceDetails() == null) {
                    bindingTemplate.setTModelInstanceDetails(new TModelInstanceDetails());
                }
                bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo().add(instanceInfo);
            }
        }
        if ((defaultCategoryBag = properties.getProperty(BINDING_CATEGORY_BAG)) != null && !"".equals(defaultCategoryBag)) {
            log.info((Object)("Adding categoryBag: " + defaultCategoryBag));
            CategoryBag categoryBag = this.parseCategoryBag(defaultCategoryBag);
            bindingTemplate.setCategoryBag(categoryBag);
        }
        return bindingTemplate;
    }
}

