/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.engine.service;

import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.soa.bpel.runtime.engine.BPELEngine;
import org.jboss.soa.bpel.runtime.engine.BPELEngineFactory;
import org.jboss.soa.bpel.runtime.engine.service.BPELEngineServiceMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.NonSerializableFactory;

public class BPELEngineService
extends ServiceMBeanSupport
implements BPELEngineServiceMBean {
    private static final Logger logger = Logger.getLogger(BPELEngineService.class);
    private String m_jndiName = null;
    private BPELEngine m_bpelEngine = null;

    protected void startService() throws Exception {
        logger.info((Object)"Starting JBoss BPEL Engine");
        this.m_bpelEngine = BPELEngineFactory.getInstance();
        this.rebind();
        this.m_bpelEngine.init();
    }

    protected void stopService() throws Exception {
        logger.info((Object)"Stopping JBoss BPEL Engine");
        this.unbind(this.m_jndiName);
        this.m_bpelEngine.close();
        this.m_bpelEngine = null;
    }

    public String getJndiName() {
        return this.m_jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        String oldName = this.m_jndiName;
        this.m_jndiName = jndiName;
        if (super.getState() == 3) {
            this.unbind(oldName);
            try {
                this.rebind();
            }
            catch (Exception e) {
                NamingException ne = new NamingException("Failed to update jndiName");
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    private void rebind() throws NamingException {
        InitialContext rootCtx = new InitialContext();
        Name fullName = rootCtx.getNameParser("").parse(this.m_jndiName);
        logger.info((Object)("fullName=" + fullName));
        NonSerializableFactory.rebind((Name)fullName, (Object)this.m_bpelEngine, (boolean)true);
    }

    private void unbind(String jndiName) {
        try {
            InitialContext rootCtx = new InitialContext();
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)jndiName);
        }
        catch (NamingException e) {
            logger.error((Object)"Failed to unbind map", (Throwable)e);
        }
    }
}

