/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.DeploymentUnitFilter;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.kernel.Kernel;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.soa.bpel.runtime.engine.ode.ExecutionEnvironment;
import org.jboss.soa.bpel.runtime.engine.ode.UDDIRegistration;
import org.jboss.soa.bpel.runtime.integration.KernelLocator;
import org.jboss.soa.bpel.runtime.integration.ServerConfig;
import org.jboss.soa.bpel.runtime.integration.ServerConfigFactory;
import org.jboss.soa.bpel.runtime.ws.AbstractWebServiceEndpoint;
import org.jboss.soa.bpel.runtime.ws.DeploymentBuilder;
import org.jboss.soa.bpel.runtime.ws.EndpointManagementException;
import org.jboss.soa.bpel.runtime.ws.EndpointMetaData;
import org.jboss.soa.bpel.runtime.ws.ServiceEndpointReference;
import org.jboss.soa.bpel.runtime.ws.WSDLParser;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;
import org.jboss.soa.bpel.runtime.ws.WebMetaDataFactory;
import org.jboss.soa.bpel.runtime.ws.WebServiceClient;
import org.jboss.soa.bpel.runtime.ws.WebServiceProviderFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

public class EndpointManager {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final String BPEL_UDDI_REGISTRATION = "uddi.registration";
    private Map<String, ServiceEndpointReference> endpointMapping = new ConcurrentHashMap<String, ServiceEndpointReference>();
    private ServerConfig serverConfig;
    private ExecutionEnvironment executionEnvironment;
    private UDDIRegistration uddiRegistration;

    public EndpointManager(ExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
        this.serverConfig = ServerConfigFactory.getServerConfig();
        if (this.isUDDIRegistration()) {
            this.uddiRegistration = new UDDIRegistration();
        }
    }

    public EndpointReference createEndpoint(EndpointMetaData metaData, WSDLReference wsdlRef, ClassLoader classLoader) throws EndpointManagementException {
        try {
            File warArchive = new DeploymentBuilder(this.serverConfig).setEndpoint(metaData.getEndpointId()).setWSDL(wsdlRef.getWsdlFile()).build();
            Deployment deployment = this.createVFSDeployment(warArchive);
            WebServiceProviderFactory providerFactory = new WebServiceProviderFactory();
            AbstractWebServiceEndpoint providerImpl = providerFactory.createProvider(metaData.getServiceName(), metaData.getPortName(), metaData.getEndpointId(), wsdlRef, classLoader);
            this.log.debug((Object)("Created dynamic endpoint class " + providerImpl.getClass().getName()));
            DelegatingClassLoaderFactory clf = new DelegatingClassLoaderFactory(classLoader);
            URL serviceUrl = new WSDLParser(wsdlRef.getDefinition()).getServiceLocationURL(metaData.getServiceName(), metaData.getPortName());
            String[] webContext = this.deriveWebContextFromServiceUrl(serviceUrl);
            WebMetaDataFactory wmdFactory = new WebMetaDataFactory(metaData.getEndpointId(), webContext[0], webContext[1], providerImpl.getClass().getName());
            MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
            mutableAttachments.addAttachment(ClassLoaderFactory.class, (Object)clf);
            mutableAttachments.addAttachment(JBossWebMetaData.class, (Object)wmdFactory.createWebMetaData(classLoader));
            mutableAttachments.addAttachment(DeploymentUnitFilter.class, (Object)new RiftsawWSDeploymentUnitFilter());
            this.getMainDeployer().deploy(new Deployment[]{deployment});
            ServiceEndpointReference ref = new ServiceEndpointReference(metaData.getEndpointId(), serviceUrl.toExternalForm(), deployment.getName());
            ref.setArchiveLocation(warArchive.getAbsolutePath());
            this.endpointMapping.put(this.createEndpointKey(metaData.getServiceName(), metaData.getPortName()), ref);
            if (this.isUDDIRegistration()) {
                this.uddiRegistration.registerEPR(metaData, wsdlRef);
            }
            return ref;
        }
        catch (Exception e) {
            throw new EndpointManagementException("Failed to create endpoint", e);
        }
    }

    private String[] deriveWebContextFromServiceUrl(URL serviceUrl) {
        String actualUrlPattern;
        String actualWebContext;
        String urlPathInfo = serviceUrl.getPath();
        if ((urlPathInfo = urlPathInfo.substring(1, urlPathInfo.length())).indexOf("/") != -1) {
            int index = urlPathInfo.indexOf("/");
            actualWebContext = urlPathInfo.substring(0, index);
            actualUrlPattern = urlPathInfo.substring(index, urlPathInfo.length()) + "/*";
        } else {
            actualWebContext = urlPathInfo;
            actualUrlPattern = "/*";
        }
        return new String[]{actualWebContext, actualUrlPattern};
    }

    private String createEndpointKey(QName service, String port) {
        return service.toString() + ":" + port;
    }

    private Deployment createVFSDeployment(File war) throws IOException {
        VirtualFile webAppVFS = VFS.getRoot((URL)war.toURL());
        return VFSDeploymentFactory.getInstance().createVFSDeployment(webAppVFS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeEndpoint(QName service, String port) throws EndpointManagementException {
        String key = this.createEndpointKey(service, port);
        ServiceEndpointReference ref = this.endpointMapping.get(key);
        if (null == ref) {
            throw new IllegalStateException("Unable to resolve ServiceEndpointReference for key: " + key);
        }
        String deploymentId = ref.getDeploymentName();
        if (ref != null) {
            try {
                this.getMainDeployer().undeploy(new String[]{deploymentId});
                this.endpointMapping.remove(key);
                File warArchive = new File(ref.getArchiveLocation());
                if (warArchive.exists()) {
                    if (!EndpointManager.deleteDirectory(warArchive)) {
                        this.log.warn((Object)(warArchive + " could no be deleted"));
                    }
                } else {
                    this.log.warn((Object)(ref.getArchiveLocation() + " cannot be removed (doesn't exist)."));
                }
                if (!this.isUDDIRegistration()) return;
                this.uddiRegistration.unRegisterEPR(service, port);
                return;
            }
            catch (Exception e) {
                throw new EndpointManagementException("Failed to undeploy " + deploymentId, e);
            }
        } else {
            this.log.warn((Object)("Endpoint not found for removal: " + key));
        }
    }

    private DeployerClient getMainDeployer() {
        Kernel mc = KernelLocator.getKernel();
        ControllerContext context = mc.getController().getInstalledContext((Object)"MainDeployer");
        DeployerClient mainDeployer = (DeployerClient)context.getTarget();
        return mainDeployer;
    }

    public EndpointReference maintains(QName service, String port) {
        String key = this.createEndpointKey(service, port);
        return this.endpointMapping.get(key);
    }

    public WebServiceClient createClient(EndpointMetaData metaData, WSDLReference wsdlRef) throws EndpointManagementException {
        try {
            WebServiceClient client = new WebServiceClient(metaData, wsdlRef, this.executionEnvironment);
            return client;
        }
        catch (Exception e) {
            throw new EndpointManagementException("Failed to create endpoint", e);
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    EndpointManager.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public boolean isUDDIRegistration() {
        return Boolean.valueOf(this.executionEnvironment.getOdeConfig().getProperty(BPEL_UDDI_REGISTRATION, "false"));
    }

    public class RiftsawWSDeploymentUnitFilter
    implements DeploymentUnitFilter {
        public boolean accepts(DeploymentUnit unit) {
            return false;
        }
    }

    public class DelegatingClassLoaderFactory
    implements ClassLoaderFactory {
        private ClassLoader delegate;

        public DelegatingClassLoaderFactory(ClassLoader delegate) {
            this.delegate = delegate;
        }

        public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
            return this.delegate;
        }

        public void removeClassLoader(DeploymentUnit unit) throws Exception {
        }
    }
}

