/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;

public final class WSDLParser {
    private Definition wsdlDefinition;
    private int dfsDepth = 0;

    public WSDLParser(Definition wsdlDefinition) {
        this.wsdlDefinition = wsdlDefinition;
    }

    public void reset() {
        this.dfsDepth = 0;
    }

    public Operation getDocLitOperation(QName service, String port, QName payloadName) {
        this.reset();
        Operation result = this._getDocLitOperation(this.wsdlDefinition, service, port, payloadName);
        if (result == null) {
            throw new IllegalArgumentException("Unable to find operation for element " + payloadName);
        }
        return result;
    }

    private Operation _getDocLitOperation(Definition wsdl, QName serviceName, String portName, QName payloadName) {
        if (++this.dfsDepth > 50) {
            throw new IllegalStateException("Recursive loop detected. DFS depth reached limit");
        }
        Collection imports = wsdl.getImports().values();
        for (List importNS : imports) {
            for (Import wsdlImport : importNS) {
                Operation result = this._getDocLitOperation(wsdlImport.getDefinition(), serviceName, portName, payloadName);
                if (result == null) continue;
                return result;
            }
        }
        Service service = wsdl.getService(serviceName);
        if (service == null) {
            return null;
        }
        Port port = service.getPort(portName);
        if (port == null) {
            throw new IllegalArgumentException("service " + serviceName + " contains no such port " + portName);
        }
        Binding binding = port.getBinding();
        PortType portType = binding.getPortType();
        List operations = portType.getOperations();
        for (Operation op : operations) {
            Message message = op.getInput().getMessage();
            Collection parts = message.getParts().values();
            for (Part part : parts) {
                if (!part.getElementName().equals(payloadName)) continue;
                return op;
            }
        }
        return null;
    }

    public URL getServiceLocationURL(QName serviceQName, String portName) {
        this.reset();
        return this._getServiceLocationURL(this.wsdlDefinition, serviceQName, portName);
    }

    public URL _getServiceLocationURL(Definition wsdl, QName serviceQName, String portName) {
        URL match = null;
        ++this.dfsDepth;
        if (this.dfsDepth > 50) {
            throw new IllegalStateException("Recursive loop detected. DFS depth reached limit");
        }
        Map imports = wsdl.getImports();
        for (String ns : imports.keySet()) {
            List importNS = (List)imports.get(ns);
            for (Import wsdlImport : importNS) {
                URL result = this._getServiceLocationURL(wsdlImport.getDefinition(), serviceQName, portName);
                if (result == null) continue;
                match = result;
                break;
            }
            if (match == null) continue;
            break;
        }
        if (match != null) {
            return match;
        }
        try {
            Service service = wsdl.getService(serviceQName);
            Port port = null;
            SOAPAddress soapAddress = null;
            if (service != null && (port = service.getPort(portName)) != null) {
                for (Object obj : port.getExtensibilityElements()) {
                    if (!(obj instanceof SOAPAddress)) continue;
                    soapAddress = (SOAPAddress)obj;
                }
            }
            if (soapAddress != null) {
                match = new URL(soapAddress.getLocationURI());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse " + wsdl, e);
        }
        return match;
    }
}

