/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;
import org.jboss.soa.bpel.runtime.ws.SOAPMessageAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSInvocationAdapter
implements InvocationAdapter<SOAPMessage> {
    private final String operationName;
    private final QName serviceName;
    private SOAPMessage soapRequestMessage;
    private SOAPMessage soapResponseMessage;
    private final SOAPMessageAdapter soapAdapter;

    public WSInvocationAdapter(String operationName, QName serviceName, SOAPMessageAdapter soapAdapter) {
        this.operationName = operationName;
        this.serviceName = serviceName;
        this.soapAdapter = soapAdapter;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    @Override
    public void parseRequest(MyRoleMessageExchange mex, Message request) {
        if (null == this.soapRequestMessage) {
            throw new IllegalArgumentException("No request SOAPMessage set");
        }
        this.soapAdapter.parseSoapRequest(request, this.soapRequestMessage, mex.getOperation());
    }

    @Override
    public void createResponse(MyRoleMessageExchange mex) {
        try {
            this.soapResponseMessage = MessageFactory.newInstance().createMessage();
            this.soapAdapter.createSoapResponse(this.soapResponseMessage, mex.getResponse(), mex.getOperation());
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to create SOAP response", e);
        }
    }

    @Override
    public void createFault(MyRoleMessageExchange mex) {
        try {
            this.soapResponseMessage = MessageFactory.newInstance().createMessage();
            this.soapAdapter.createSoapFault(this.soapResponseMessage, mex.getFaultResponse().getMessage(), mex.getFault(), mex.getOperation());
        }
        catch (SOAPException e) {
            throw new RuntimeException("Failed to create SOAP fault", e);
        }
    }

    @Override
    public SOAPMessage getInvocationResult() {
        if (null == this.soapResponseMessage) {
            throw new IllegalArgumentException("No response SOAPMessage set");
        }
        return this.soapResponseMessage;
    }

    public void setSOAPMessage(SOAPMessage soapMessage) {
        this.soapRequestMessage = soapMessage;
    }
}

