/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime.engine;

import javax.xml.namespace.QName;

import org.w3c.dom.Element;

/**
 * This exception represents a BPEL fault returns as the result of
 * an invocation on a service.
 * 
 * @author gbrown
 *
 */
public class BPELFault extends Exception {

	private static final long serialVersionUID = 5232665438135478453L;

	/**
	 * This constructor initialises the BPEL fault with a qualified
	 * name and the fault message content.
	 * 
	 * @param faultName The fault name
	 * @param faultMesg The fault message
	 */
	public BPELFault(QName faultName, Element faultMesg) {
		super("BPEL Fault '"+faultName+"'");
		
		m_faultName = faultName;
		m_faultMesg = faultMesg;
	}
	
	/**
	 * This method returns the full qualified name of the
	 * fault.
	 * 
	 * @return The fault name
	 */
	public QName getFaultName() {
		return(m_faultName);
	}
	
	/**
	 * This method returns the fault message content.
	 * 
	 * @return The fault message
	 */
	public Element getFaultMessage() {
		return(m_faultMesg);
	}
	
	private QName m_faultName=null;
	private Element m_faultMesg=null;
}
