/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime.engine;

/**
 * This interface provides the main interface to the integration
 * layer used by the BPEL engine to invoke external services.
 * 
 * @author gbrown
 *
 */
public interface IntegrationLayer {

	/**
	 * This method requests a channel to a partner (i.e. external
	 * service), based on the supplied endpoint reference. The
	 * integration layer will only return a channel if it is
	 * capable of providing access to the service associated with
	 * the endpoint reference.
	 * 
	 * @param ref The endpoint reference
	 * @return The partner channel, or null if the integration
	 * 					layer cannot interpret the endpoint reference
	 */
	// TODO: How do we deal with connection oriented failures - where
	// integration layer understands the reference, but has a technical
	// problem establishing the channel?
	public PartnerChannel createChannel(EndpointReference ref);
	
}
