/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.bpel.runtime.engine;

import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;

import javax.xml.namespace.QName;

/**
 * Hides the message translation details when invoking ODE from
 * an external component (i.e. ESB or WS).
 *
 * @see org.jboss.soa.bpel.runtime.engine.BPELEngine#invoke(InvocationAdapter)
 *  
 * @author Heiko Braun <hbraun@redhat.com>
 */
public interface InvocationAdapter<T>
{
  String getOperationName();
  QName getServiceName();

  /**
   * Callback from the Engine towards the adapter when
   * turning an external message representation into an ODE request {@link org.apache.ode.bpel.iapi.Message}
   * @param mex
   * @param odeRequest
   */
  void parseRequest(MyRoleMessageExchange mex, Message odeRequest);

  /**
   * Callback from the Engine towards the adapter when
   * turning an ODE response {@link org.apache.ode.bpel.iapi.Message} into an external format &lt;T>
   * @param mex
   */
  void createResponse(MyRoleMessageExchange mex);

  /**
   * Access the invocation result (response)
   * @return T
   */
  T getInvocationResult();

}
