/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime.engine.ode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.*;
import org.jboss.soa.bpel.runtime.engine.EndpointReference;
import org.jboss.soa.bpel.runtime.engine.IntegrationLayer;
import org.jboss.soa.bpel.runtime.engine.PartnerChannel;
import org.w3c.dom.Document;

import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;

public class BindingContextImpl implements BindingContext {
    protected final Log __log = LogFactory.getLog(getClass());

    private BPELEngineImpl _server;

    public BindingContextImpl(BPELEngineImpl server) {
        _server = server;
    }

    public org.apache.ode.bpel.iapi.EndpointReference activateMyRoleEndpoint(QName processId, Endpoint myRoleEndpoint) {
    	__log.info("*** ACTIVATING MY ROLE ENDPOINT: "+myRoleEndpoint);


    	ProcessConf pconf = _server._store.getProcessConfiguration(processId);
        Definition wsdl = pconf.getDefinitionForService(myRoleEndpoint.serviceName);
        if (wsdl == null)
            throw new ContextException("Unable to access WSDL definition to activate MyRole endpoint for service " + myRoleEndpoint.serviceName
                        + " and port " + myRoleEndpoint.portName);
        //ODEService svc = createService(pconf, myRoleEndpoint.serviceName, myRoleEndpoint.portName);
        //return svc.getMyServiceRef();

        // TODO: TEAM_ODE: Need to work out what endpoint ref should be provided - especially
        // if service available via ESB and WS stack
        // This method should also be used to activate/register the endpoint in the
        // relevant transport layers

        org.apache.ode.bpel.iapi.EndpointReference ret=new TmpEndpointReference();
        return(ret);
    }

    public void deactivateMyRoleEndpoint(Endpoint myRoleEndpoint) {
    	__log.info("*** DEACTIVATING MY ROLE ENDPOINT: "+myRoleEndpoint);
        //destroyService(myRoleEndpoint.serviceName, myRoleEndpoint.portName);
    }

    public PartnerRoleChannel createPartnerRoleChannel(QName processId, PortType portType,
                                                       Endpoint initialPartnerEndpoint) {
        // NOTE: This implementation assumes that the initial value of the
        // partner role determines the binding.
        ProcessConf pconf = _server._store.getProcessConfiguration(processId);
        Definition wsdl = pconf.getDefinitionForService(initialPartnerEndpoint.serviceName);
        if (wsdl == null) {
            throw new ContextException("Cannot find definition for service " + initialPartnerEndpoint.serviceName
                    + " in the context of process " + processId);
        }
        //return createExternalService(pconf, initialPartnerEndpoint.serviceName, initialPartnerEndpoint.portName);

        // TODO: TEAM_ODE:
        // 1) try to obtain EPR from wsdl, associated with service and port name - see createExternalService
        //							code below for possible use of ProcessConf to get external service WSDL
        // 2) if not found, then do uddi lookup using service and port name
        // 3) if multiple EPRs found, use some mechanism for selecting
        // 4) find transport layer associated with the EPR
        // 5) create channel on transport layer associated with EPR

        IntegrationLayer tl=null;
        EndpointReference epr=null;
        PartnerChannel channel=null;

        if (tl != null) {
        	channel = tl.createChannel(epr);
        }
        
        PartnerRoleChannel ret=new PartnerRoleChannelImpl(channel);

        return(ret);
    }

    /*
    protected ODEService createService(ProcessConf pconf, QName serviceName, String portName) throws AxisFault {
        AxisService axisService = ODEAxisService.createService(_server._axisConfig, pconf, serviceName, portName);
        ODEService odeService = new ODEService(axisService, pconf, serviceName, portName, _server._bpelServer);

        destroyService(serviceName, portName);
        _services.put(serviceName, portName, odeService);

        // Setting our new service on the ODE receiver
        Iterator operationIterator = axisService.getOperations();
        while (operationIterator.hasNext()) {
            AxisOperation op = (AxisOperation) operationIterator.next();
            if (op.getMessageReceiver() instanceof ODEMessageReceiver) {
                ((ODEMessageReceiver) op.getMessageReceiver()).setService(odeService);
                break;
            }
        }

        // We're public!
        _server._axisConfig.addService(axisService);
        __log.debug("Created Axis2 service " + serviceName);
        return odeService;
    }


    protected void destroyService(QName serviceName, String portName) {
        __log.debug("Destroying service " + serviceName + " port " + portName);
        ODEService service = (ODEService) _services.remove(serviceName, portName);
        if (service != null) {
            // try to clean up the service after itself
            try {
                String axisServiceName = service.getAxisService().getName();
                AxisService axisService = _server._axisConfig.getService(axisServiceName);
                // first, de-allocate its schemas
                axisService.releaseSchemaList();
                // then, de-allocate its parameters
                // the service's wsdl object model is stored as one of its parameters!
                // can't stress strongly enough how important it is to clean this up.
                ArrayList<Parameter> parameters = (ArrayList<Parameter>) axisService.getParameters();
                for (Parameter parameter : parameters) {
                    axisService.removeParameter(parameter);
                }
                // now, stop the service
                _server._axisConfig.stopService(axisServiceName);
                // calling removeServiceGroup() is workaround to AXIS2-4314.
                //  It happens that Axis2 creates one group per service you add with AxisConfiguration.addService(). See this.createService()
                // Once this issue is fixed (hopully in Axis2-1.5), we can use removeService() again.
                _server._axisConfig.removeServiceGroup(axisServiceName);
                _server._axisConfig.cleanup();
            } catch (AxisFault axisFault) {
                __log.error("Couldn't destroy service " + serviceName);
            }
        } else {
            __log.debug("Couldn't find service " + serviceName + " port " + portName + " to destroy.");
        }
    }

    protected ExternalService createExternalService(ProcessConf pconf, QName serviceName, String portName) throws ContextException {
        ExternalService extService = null;

        Definition def = pconf.getDefinitionForService(serviceName);
        try {
            if (WsdlUtils.useHTTPBinding(def, serviceName, portName)) {
                if (__log.isDebugEnabled()) __log.debug("Creating HTTP-bound external service " + serviceName);
                extService = new HttpExternalService(pconf, serviceName, portName, _server._bpelServer, _server.httpConnectionManager);
            } else if (WsdlUtils.useSOAPBinding(def, serviceName, portName)) {
                if (__log.isDebugEnabled()) __log.debug("Creating SOAP-bound external service " + serviceName);
                extService = new SoapExternalService(def, serviceName, portName, _server._axisConfig, pconf, _server.httpConnectionManager);
            }
        } catch (Exception ex) {
            __log.error("Could not create external service.", ex);
            throw new ContextException("Error creating external service! name:" + serviceName + ", port:" + portName, ex);
        }

        // if not SOAP nor HTTP binding
        if (extService == null) {
            throw new ContextException("Only SOAP and HTTP binding supported!");
        }

        __log.debug("Created external service " + serviceName);
        return extService;
    }
*/

    public class TmpEndpointReference implements org.apache.ode.bpel.iapi.EndpointReference {

		public Document toXML() {
			Document ret=null;

			try {
				ret = javax.xml.parsers.DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

				org.w3c.dom.Element elem=ret.createElement("attr");
				elem.setAttribute("location", "temp");

				ret.appendChild(elem);
			} catch(Exception e) {
				e.printStackTrace();
			}

			return(ret);
		}

    }

	//@Override
	public long calculateSizeofService(org.apache.ode.bpel.iapi.EndpointReference ref) {
		return 0;
	}
}
