/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import org.apache.ode.bpel.iapi.EndpointReference;
import org.w3c.dom.Document;

/**
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public final class ServiceEndpointReference implements EndpointReference
{
  private String endpointId;
  private String location;
  private String deploymentName;

  public ServiceEndpointReference(String endpointId, String location, String deploymentName)
  {
    this.endpointId = endpointId;
    this.location = location;
    this.deploymentName = deploymentName;
  }

  public Document toXML() {
    Document ret=null;

    try {
      ret = javax.xml.parsers.DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

      org.w3c.dom.Element elem=ret.createElement("attr");
      elem.setAttribute("location", location);
      elem.setAttribute("endpointId", endpointId);
      elem.setAttribute("deploymentName", deploymentName);

      ret.appendChild(elem);
    } catch(Exception e) {
      e.printStackTrace();
    }

    return(ret);
  }

  public String getEndpointId()
  {
    return endpointId;
  }

  public String getLocation()
  {
    return location;
  }

  public String getDeploymentName()
  {
    return deploymentName;
  }
}
