/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.jboss.soa.bpel.runtime.engine.InvocationAdapter;

import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

/**
 * @author Heiko Braun <hbraun@redhat.com>
 */
public final class WSInvocationAdapter implements InvocationAdapter<SOAPMessage>
{
  private final String operationName;
  private final QName serviceName;

  private SOAPMessage soapRequestMessage;
  private SOAPMessage soapResponseMessage;

  private final SOAPMessageAdapter soapAdapter;

  public WSInvocationAdapter(String operationName,
      QName serviceName, SOAPMessageAdapter soapAdapter)
  {
    this.operationName = operationName;
    this.serviceName = serviceName;    
    this.soapAdapter = soapAdapter;
  }

  public String getOperationName()
  {
    return operationName;
  }

  public QName getServiceName()
  {
    return serviceName;
  }

  public void parseRequest(MyRoleMessageExchange mex, Message request)
  {
    if(null==soapRequestMessage)
      throw new IllegalArgumentException("No request SOAPMessage set");
    
    soapAdapter.parseSoapRequest(request, soapRequestMessage, mex.getOperation());
  }
  
  public void createResponse(MyRoleMessageExchange mex)
  {
    try
    {
      // create SOAPEnvelope
      soapResponseMessage = MessageFactory.newInstance().createMessage();
      soapAdapter.createSoapResponse(soapResponseMessage, mex.getResponse(), mex.getOperation());
    }
    catch (SOAPException e)
    {
      throw new RuntimeException("Failed to parse SOAP response", e);
    }
  }

  public SOAPMessage getInvocationResult()
  {
    if(null==soapResponseMessage)
      throw new IllegalArgumentException("No response SOAPMessage set");

    return soapResponseMessage; 
  }

  public void setSOAPMessage(SOAPMessage soapMessage)
  {
    this.soapRequestMessage = soapMessage;
  }
}
