/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;

public class Runner
{
  static QName service;
  static String port;

  public static void main(String[] args) throws Exception
  {
     // HelloWorldProcessRequest

    WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
    Definition wsdlDefinition = wsdlReader.readWSDL(
        "file:///Users/hbraun/dev/env/riftsaw-distro/jbossesb-4.6/samples/quickstarts/webservice_esb_bpel/bpel/wsdl/BPELRetailer.wsdl"
    );

    service = new QName("http://www.jboss.org/samples/bpel/Retailer.wsdl", "RetailerService");
    port = "RetailerPort";

    SOAPMessageAdapter soapAdapter =new SOAPMessageAdapter(wsdlDefinition, service, port);

    System.out.println("RPC ? "+soapAdapter.isRPC());

    WSDLParser parser = new WSDLParser(wsdlDefinition);
    Operation op = parser.getDocLitOperation(
        service, port, new QName("http://www.jboss.org/samples/bpel/CustomerOrder.xsd", "customerOrder")
    );

    System.out.println("operation: "+op.getName());

    System.out.println(
        "URL: " + parser.getServiceLocationURL(service, port)
    );
  }

}
