/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.soa.bpel.runtime.engine.BPELEngine;
import org.jboss.soa.bpel.runtime.ws.DOMWriter;
import org.jboss.soa.bpel.runtime.ws.SOAPMessageAdapter;
import org.jboss.soa.bpel.runtime.ws.WSDLParser;
import org.jboss.soa.bpel.runtime.ws.WSInvocationAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseWebServiceEndpoint
implements Provider<SOAPMessage> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private SOAPMessageAdapter soapAdapter;
    private QName serviceQName;
    private Definition wsdlDefinition;
    private boolean isInitialized;

    private void init() {
        if (!this.isInitialized) {
            try {
                WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
                this.wsdlDefinition = wsdlReader.readWSDL(this.getWsdlLocation());
                this.serviceQName = QName.valueOf(this.getServiceName());
                this.soapAdapter = new SOAPMessageAdapter(this.wsdlDefinition, this.serviceQName, this.getPortName());
            }
            catch (WSDLException e) {
                throw new RuntimeException("Failed to parse WSDL", e);
            }
            this.isInitialized = true;
        }
    }

    public SOAPMessage invoke(SOAPMessage soapMessage) {
        this.log.debug((Object)("Invoking endpoint " + this.getEndpointId()));
        this.init();
        try {
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
            Element messageElement = BaseWebServiceEndpoint.getMessagePayload(soapEnvelope);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("ODE inbound message: \n" + DOMWriter.printNode((Node)soapEnvelope, true)));
            }
            String operationName = this.resolveOperationName(messageElement);
            WSInvocationAdapter invocationContext = new WSInvocationAdapter(operationName, this.serviceQName, this.getPortName(), this.soapAdapter);
            invocationContext.setSOAPMessage(soapMessage);
            this.getEngine().invoke(invocationContext);
            SOAPMessage responseMessage = null;
            if (this.isResponseExpected(messageElement)) {
                responseMessage = invocationContext.getInvocationResult();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("ODE outbound message: \n" + DOMWriter.printNode((Node)responseMessage.getSOAPPart().getEnvelope(), true)));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ODE no outbound message");
            }
            if (responseMessage == null) {
                this.log.debug((Object)"No response, probably due to oneway request");
                responseMessage = MessageFactory.newInstance().createMessage();
            }
            return responseMessage;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke BPEL process: " + e.getMessage(), e);
        }
    }

    public String resolveOperationName(Element payload) {
        if (this.soapAdapter.isRPC()) {
            return payload.getLocalName();
        }
        QName elementName = new QName(payload.getNamespaceURI(), payload.getLocalName());
        Operation op = new WSDLParser(this.wsdlDefinition).getDocLitOperation(this.serviceQName, this.getPortName(), elementName);
        return op.getName();
    }

    public boolean isResponseExpected(Element payload) {
        Operation op = null;
        if (this.soapAdapter.isRPC()) {
            QName elementName = new QName(payload.getNamespaceURI(), payload.getLocalName());
            op = new WSDLParser(this.wsdlDefinition).getRPCOperation(this.serviceQName, this.getPortName(), elementName);
        } else {
            QName elementName = new QName(payload.getNamespaceURI(), payload.getLocalName());
            op = new WSDLParser(this.wsdlDefinition).getDocLitOperation(this.serviceQName, this.getPortName(), elementName);
        }
        if (op == null) {
            throw new RuntimeException("Failed to locate operation definition for: " + payload);
        }
        return op.getOutput() != null;
    }

    public static Element getMessagePayload(SOAPEnvelope soapEnvelope) throws SOAPException {
        SOAPBody body = soapEnvelope.getBody();
        Element messageElement = null;
        NodeList children = body.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node tmp = children.item(i);
            if (1 != tmp.getNodeType()) continue;
            messageElement = (Element)tmp;
            break;
        }
        return messageElement;
    }

    public String getEndpointId() {
        return null;
    }

    public String getServiceName() {
        return null;
    }

    public String getWsdlLocation() {
        return null;
    }

    public String getPortName() {
        return null;
    }

    private BPELEngine getEngine() {
        try {
            InitialContext ctx = new InitialContext();
            return (BPELEngine)ctx.lookup("bpel/Engine");
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to initialize BPEL engine");
        }
    }
}

