/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.runtime.ws;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils {
    protected static final Log log = LogFactory.getLog(JavaUtils.class);

    public static boolean isJBossRepositoryClassLoader(ClassLoader loader) {
        Class<?> clazz = loader.getClass();
        while (!clazz.getName().startsWith("java")) {
            if ("org.jboss.mx.loading.RepositoryClassLoader".equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static void clearBlacklists(ClassLoader loader) {
        if (JavaUtils.isJBossRepositoryClassLoader(loader)) {
            for (Method m : loader.getClass().getMethods()) {
                if (!"clearBlackLists".equalsIgnoreCase(m.getName())) continue;
                try {
                    m.invoke((Object)loader, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getSoapMessageASString(SOAPMessage soapMessage) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)outputStream);
            byte[] byteArray = outputStream.toByteArray();
            String soapMsg = new String(byteArray, "UTF-8");
            return soapMsg;
        }
        catch (Exception e) {
            log.error((Object)"Error in converting SOAPMessage into String");
            return null;
        }
    }
}

