/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.engine.ode;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.jboss.soa.bpel.runtime.ClassUtil;

/**
 * 
 * @author Kurt T Stam <kurt.stam@jboss.com>
 *
 */
public class UDDIClientFactory {	
	
	private static Logger log = Logger.getLogger(UDDIClientFactory.class);
	public static final String UDDI_REGISTRATION_IMPL="bpel.uddi.client.impl";
	public static final String DEFAULT_UDDI_REG_IMPL="org.jboss.soa.bpel.uddi.UDDIRegistrationImpl";
	
	public static UDDIRegistration newInstance(Properties properties) throws ClassNotFoundException, 
		InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException {
		
		String uddiRegistrationImpl = properties.getProperty(UDDI_REGISTRATION_IMPL,DEFAULT_UDDI_REG_IMPL);
		Class<?> regClass = null;
		try {
			regClass = ClassUtil.forName(uddiRegistrationImpl, UDDIClientFactory.class);
		} catch (ClassNotFoundException cnfe) {
				log.error("Could not find class " + UDDI_REGISTRATION_IMPL);
				throw cnfe;
		}
		UDDIRegistration uddiRegistration = (UDDIRegistration) regClass.getConstructor(Properties.class).newInstance(properties);
		return uddiRegistration;
	}
}
