/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.bpel.runtime.ws;

import org.apache.ode.bpel.iapi.EndpointReference;
import org.w3c.dom.Document;

/**
 * References webservice endpoint deployment properties.
 *  
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public final class ServiceEndpointReference implements EndpointReference
{
  private String endpointId;
  private String serviceUrl;
  private String deploymentName;
  private String archiveLocation;

  public ServiceEndpointReference(String endpointId, String location, String deploymentName)
  {
    this.endpointId = endpointId;
    this.serviceUrl = location;
    this.deploymentName = deploymentName;
  }

  public String getArchiveLocation()
  {
    return archiveLocation;
  }

  public void setArchiveLocation(String archiveLocation)
  {
    this.archiveLocation = archiveLocation;
  }

  public Document toXML() {
    Document ret=null;

    try {
      ret = javax.xml.parsers.DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();

      org.w3c.dom.Element elem=ret.createElement("attr");
      elem.setAttribute("location", serviceUrl);
      elem.setAttribute("endpointId", endpointId);
      elem.setAttribute("deploymentName", deploymentName);

      ret.appendChild(elem);
    } catch(Exception e) {
      e.printStackTrace();
    }

    return(ret);
  }

  public String getEndpointId()
  {
    return endpointId;
  }

  public String getServiceUrl()
  {
    return serviceUrl;
  }

  public String getDeploymentName()
  {
    return deploymentName;
  }

  @Override
  public boolean equals(Object o)
  {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ServiceEndpointReference that = (ServiceEndpointReference) o;

    if (!archiveLocation.equals(that.archiveLocation)) return false;
    if (!deploymentName.equals(that.deploymentName)) return false;
    if (!endpointId.equals(that.endpointId)) return false;
    if (!serviceUrl.equals(that.serviceUrl)) return false;

    return true;
  }

  @Override
  public int hashCode()
  {
    int result = endpointId.hashCode();
    result = 31 * result + serviceUrl.hashCode();
    result = 31 * result + deploymentName.hashCode();
    result = 31 * result + archiveLocation.hashCode();
    return result;
  }
}
