/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.uddi300;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.api_v3.AccessPointType;
import org.apache.juddi.v3.annotations.AnnotationProcessor;
import org.apache.juddi.v3.client.config.TokenResolver;
import org.apache.juddi.v3.client.config.UDDIClerk;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.transport.TransportException;
import org.jboss.soa.bpel.runtime.engine.ode.UDDIRegistration;
import org.jboss.soa.bpel.runtime.ws.WSDLReference;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.GetAuthToken;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ServiceInfo;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.uddi.v3_service.DispositionReportFaultMessage;

@Deprecated
public class UDDI300RegistrationImpl
extends AnnotationProcessor
implements UDDIRegistration {
    protected static final Log log = LogFactory.getLog(UDDI300RegistrationImpl.class);
    private Properties properties = new Properties();
    private UDDIClerk bpelClerk = null;
    private static final String BPEL_UDDI_CLERK = "bpel.uddi.clerk";
    private static final String DEFAULT_BPEL_UDDI_CLERK = "BPELClerk";
    public static final String DEFAULT_SERVICE_KEY_FORMAT = "uddi:${keyDomain}:bpel-services-";
    public static final String DEFAULT_BINDING_KEY_FORMAT = "uddi:${keyDomain}:bindings-";
    public static final String LANG = "lang";
    public static final String SERVICE_DESCRIPTION = "serviceDescription";
    public static final String SERVICE_CATEGORY_BAG = "serviceCategoryBag";
    public static final String BINDING_DESCRIPTION = "bindingDescription";
    public static final String BINDING_CATEGORY_BAG = "bindingCategoryBag";
    public static final String BINDING_TMODEL_KEYS = "bindingTModelKeys";
    public static final String SERVICE_KEY_FORMAT = "serviceKeyFormat";
    public static final String BINDING_KEY_FORMAT = "bindingKeyFormat";

    public UDDI300RegistrationImpl(Properties properties) {
        this.properties = properties;
    }

    private String getClerkName() {
        return this.properties.getProperty(BPEL_UDDI_CLERK, DEFAULT_BPEL_UDDI_CLERK);
    }

    private UDDIClerk getBPELClerk() throws ConfigurationException {
        if (this.bpelClerk == null) {
            Map clerks = UDDIClerkManager.getClientConfig().getUDDIClerks();
            this.bpelClerk = (UDDIClerk)clerks.get(this.getClerkName());
            if (this.bpelClerk == null) {
                throw new ConfigurationException("Could not find UDDI Clerk named " + this.getClerkName());
            }
        }
        return this.bpelClerk;
    }

    public void registerEPR(String serviceName, String portName, URL accessUrl) {
        boolean selfRegister = false;
        try {
            selfRegister = UDDIClerkManager.getClientConfig().isRegisterOnStartup();
            if (selfRegister) {
                UDDIClerk bpelClerk = this.getBPELClerk();
                try {
                    BusinessService service = this.createBusinessService(bpelClerk, serviceName, portName, accessUrl);
                    bpelClerk.register(service, bpelClerk.getUDDINode().getApiNode());
                }
                catch (Exception e) {
                    log.error((Object)("Unable to register service " + serviceName + " ." + e.getMessage()), (Throwable)e);
                }
                catch (Throwable t) {
                    log.error((Object)("Unable to register service " + serviceName + " ." + t.getMessage()), t);
                }
            }
        }
        catch (ConfigurationException ce) {
            if (selfRegister) {
                log.error((Object)ce.getMessage(), (Throwable)ce);
            }
            log.info((Object)ce.getMessage());
        }
    }

    public void unRegisterEPR(QName service, String port) {
        block10: {
            boolean selfRegister = false;
            try {
                selfRegister = UDDIClerkManager.getClientConfig().isRegisterOnStartup();
                if (!selfRegister) break block10;
                Map clerks = UDDIClerkManager.getClientConfig().getUDDIClerks();
                UDDIClerk bpelClerk = (UDDIClerk)clerks.get(this.getClerkName());
                String bindingName = service.getLocalPart() + "-" + port;
                if (bpelClerk != null) {
                    try {
                        Properties properties = bpelClerk.getUDDINode().getProperties();
                        String bindingKey = TokenResolver.replaceTokens((String)(DEFAULT_BINDING_KEY_FORMAT + bindingName), (Properties)properties);
                        if (properties.containsKey(BINDING_KEY_FORMAT)) {
                            bindingKey = TokenResolver.replaceTokens((String)((String)properties.get(BINDING_KEY_FORMAT) + bindingName), (Properties)properties);
                        }
                        bindingKey = bindingKey.toLowerCase();
                        BindingTemplate binding = null;
                        try {
                            binding = bpelClerk.findServiceBinding(bindingKey, bpelClerk.getUDDINode().getApiNode());
                            BusinessService businessService = bpelClerk.findService(binding.getServiceKey(), bpelClerk.getUDDINode().getApiNode());
                            bpelClerk.unRegister(businessService, bpelClerk.getUDDINode().getApiNode());
                            break block10;
                        }
                        catch (Exception e) {
                            log.warn((Object)("Could not find BindingTemplate with key " + bindingKey + " for unRegistration."));
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to unRegister EPR " + bindingName + " ." + e.getMessage()), (Throwable)e);
                    }
                    catch (Throwable t) {
                        log.error((Object)("Unable to unRegister EPR " + bindingName + " ." + t.getMessage()), t);
                    }
                    break block10;
                }
                throw new ConfigurationException("Could not find UDDI Clerk named " + this.getClerkName());
            }
            catch (ConfigurationException ce) {
                if (selfRegister) {
                    log.error((Object)ce.getMessage(), (Throwable)ce);
                }
                log.info((Object)ce.getMessage());
            }
        }
    }

    private BusinessService createBusinessService(UDDIClerk clerk, String serviceName, String portName, URL accessUrl) throws DispositionReportFaultMessage, RemoteException, ConfigurationException, TransportException {
        BusinessService service;
        block6: {
            Properties properties = clerk.getUDDINode().getProperties();
            String serviceKey = TokenResolver.replaceTokens((String)(DEFAULT_SERVICE_KEY_FORMAT + serviceName), (Properties)properties);
            if (properties.containsKey(SERVICE_KEY_FORMAT)) {
                serviceKey = TokenResolver.replaceTokens((String)((String)properties.get(SERVICE_KEY_FORMAT) + serviceName), (Properties)properties);
            }
            service = null;
            try {
                service = clerk.findService(serviceKey, clerk.getUDDINode().getApiNode());
                log.debug((Object)("Service " + serviceName + " already present in the UDDI Registry"));
            }
            catch (Exception e) {
                log.debug((Object)("Constructing Service UDDI Information for " + serviceName));
                service = new BusinessService();
                service.setBusinessKey(TokenResolver.replaceTokens((String)"uddi:${keyDomain}:${businessKey}", (Properties)properties));
                service.setServiceKey(serviceKey);
                if (properties.containsKey(SERVICE_DESCRIPTION)) {
                    Description description = new Description();
                    String lang = "en";
                    if (properties.containsKey(LANG)) {
                        lang = properties.getProperty(LANG);
                    }
                    description.setLang(lang);
                    description.setValue(properties.getProperty(SERVICE_DESCRIPTION));
                    Name sName = new Name();
                    sName.setLang(lang);
                    sName.setValue(serviceName);
                    service.getName().add(sName);
                    service.getDescription().add(description);
                }
                if (!properties.containsKey(SERVICE_CATEGORY_BAG)) break block6;
                String defaultCategoryBag = properties.getProperty(SERVICE_CATEGORY_BAG);
                log.info((Object)("Adding categoryBag: " + defaultCategoryBag));
                CategoryBag categoryBag = this.parseCategoryBag(defaultCategoryBag);
                service.setCategoryBag(categoryBag);
            }
        }
        BindingTemplate binding = this.createBindingTemplate(clerk, serviceName, portName, accessUrl);
        if (service.getBindingTemplates() == null) {
            BindingTemplates bindingTemplates = new BindingTemplates();
            service.setBindingTemplates(bindingTemplates);
        }
        service.getBindingTemplates().getBindingTemplate().add(binding);
        return service;
    }

    private BindingTemplate createBindingTemplate(UDDIClerk clerk, String serviceName, String portName, URL accessURL) {
        String defaultCategoryBag;
        Properties properties = clerk.getUDDINode().getProperties();
        BindingTemplate bindingTemplate = new BindingTemplate();
        String bindingKey = TokenResolver.replaceTokens((String)(DEFAULT_BINDING_KEY_FORMAT + serviceName + "-" + portName), (Properties)properties);
        if (properties.containsKey(BINDING_KEY_FORMAT)) {
            bindingKey = TokenResolver.replaceTokens((String)((String)properties.get(BINDING_KEY_FORMAT) + serviceName + "-" + portName), (Properties)properties);
        }
        bindingTemplate.setBindingKey(bindingKey);
        String lang = "en";
        if (properties.containsKey(LANG)) {
            lang = properties.getProperty(LANG);
        }
        if (properties.containsKey(BINDING_DESCRIPTION)) {
            Description bindingDescription = new Description();
            bindingDescription.setLang(lang);
            bindingDescription.setValue(properties.getProperty(BINDING_DESCRIPTION));
            bindingTemplate.getDescription().add(bindingDescription);
        }
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setUseType(AccessPointType.WSDL_DEPLOYMENT.toString());
        accessURL = this.rewriteWSDLURL(accessURL);
        accessPoint.setValue(accessURL.toExternalForm());
        bindingTemplate.setAccessPoint(accessPoint);
        String defaultTModelKeys = properties.getProperty("tModelKeys");
        if (defaultTModelKeys != null && !"".equals(defaultTModelKeys)) {
            String[] tModelKeys;
            for (String tModelKey : tModelKeys = defaultTModelKeys.split(",")) {
                TModelInstanceInfo instanceInfo = new TModelInstanceInfo();
                instanceInfo.setTModelKey(tModelKey);
                if (bindingTemplate.getTModelInstanceDetails() == null) {
                    bindingTemplate.setTModelInstanceDetails(new TModelInstanceDetails());
                }
                bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfo().add(instanceInfo);
            }
        }
        if ((defaultCategoryBag = properties.getProperty(BINDING_CATEGORY_BAG)) != null && !"".equals(defaultCategoryBag)) {
            log.info((Object)("Adding categoryBag: " + defaultCategoryBag));
            CategoryBag categoryBag = this.parseCategoryBag(defaultCategoryBag);
            bindingTemplate.setCategoryBag(categoryBag);
        }
        return bindingTemplate;
    }

    public WSDLReference lookupWSDL(QName serviceQName, String portName) {
        try {
            UDDIClerk bpelClerk = this.getBPELClerk();
            FindService findService = new FindService();
            findService.setAuthInfo(this.getAuthToken(bpelClerk));
            Name serviceName = new Name();
            String lang = "en";
            if (this.properties.containsKey(LANG)) {
                lang = this.properties.getProperty(LANG);
            }
            serviceName.setLang(lang);
            serviceName.setValue(serviceQName.getLocalPart());
            findService.getName().add(serviceName);
            FindQualifiers findQualifiers = new FindQualifiers();
            findQualifiers.getFindQualifier().add("exactMatch");
            findService.setFindQualifiers(findQualifiers);
            ServiceList serviceList = bpelClerk.getUDDINode().getTransport().getUDDIInquiryService().findService(findService);
            if (serviceList.getServiceInfos() != null) {
                List serviceInfos = serviceList.getServiceInfos().getServiceInfo();
                for (ServiceInfo serviceInfo : serviceInfos) {
                    String serviceKey = serviceInfo.getServiceKey();
                    BusinessService service = bpelClerk.findService(serviceKey, bpelClerk.getUDDINode().getApiNode());
                    BindingTemplates bindingTemplates = service.getBindingTemplates();
                    if (bindingTemplates == null) {
                        log.warn((Object)("Found service " + serviceQName.getLocalPart() + " with serviceKey '" + serviceInfo.getServiceKey() + "'" + " but no EPRs"));
                        continue;
                    }
                    log.info((Object)("Found service " + serviceQName.getLocalPart() + " with serviceKey '" + serviceInfo.getServiceKey() + "'" + " and " + bindingTemplates.getBindingTemplate().size() + " EPRs"));
                    for (BindingTemplate bindingTemplate : bindingTemplates.getBindingTemplate()) {
                        AccessPoint accessPoint = bindingTemplate.getAccessPoint();
                        if (AccessPointType.WSDL_DEPLOYMENT.toString().equals(accessPoint.getUseType())) {
                            URL url = null;
                            try {
                                url = new URL(accessPoint.getValue());
                                log.info((Object)("wsdlUrl for service " + serviceQName.getLocalPart() + " is " + url));
                                WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
                                Definition def = wsdlReader.readWSDL(url.toExternalForm());
                                Port port = def.getService(serviceQName).getPort(portName);
                                if (port != null) {
                                    return new WSDLReference(def, url.toURI());
                                }
                                log.info((Object)("PortName " + portName + " could not be found in WSDL"));
                            }
                            catch (Exception e) {
                                log.warn((Object)("Unable to obtain WSDL from " + url + ". " + e.getMessage()), (Throwable)e);
                            }
                            continue;
                        }
                        log.debug((Object)("This accessPoint is of type " + accessPoint.getUseType() + " only " + AccessPointType.WSDL_DEPLOYMENT + " is supported at the moment."));
                    }
                }
            } else {
                log.info((Object)("No Service by the name " + serviceQName.getLocalPart() + " was found in the registry."));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)"No WSDL could be obtained using the UDDI Registry Lookup.");
        return null;
    }

    private String getAuthToken(UDDIClerk clerk) throws TransportException, DispositionReportFaultMessage, RemoteException {
        String endpointURL = clerk.getUDDINode().getApiNode().getSecurityUrl();
        GetAuthToken getAuthToken = new GetAuthToken();
        getAuthToken.setUserID(clerk.getPublisher());
        getAuthToken.setCred(clerk.getPassword());
        String authToken = clerk.getUDDINode().getTransport().getUDDISecurityService(endpointURL).getAuthToken(getAuthToken).getAuthInfo();
        return authToken;
    }

    public URL rewriteWSDLURL(URL urlIn) {
        URL outUrl = urlIn;
        try {
            String urlString = this.getWebserviceBaseUrl() + urlIn.getFile() + "?wsdl";
            outUrl = new URL(urlString);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return outUrl;
    }

    private String getWebserviceBaseUrl() {
        return this.properties.getProperty("webservice.baseurl", "http://localhost:8080");
    }
}

