create table ODE_SCHEMA_VERSION(VERSION integer);
insert into ODE_SCHEMA_VERSION values (5);
-- Apache ODE - SimpleScheduler Database Schema
-- 
-- Apache Derby scripts by Maciej Szefler.
-- 
-- 

CREATE TABLE ode_job (
  jobid CHAR(64)  NOT NULL DEFAULT '',
  ts BIGINT  NOT NULL DEFAULT 0,
  nodeid char(64),
  scheduled int  NOT NULL DEFAULT 0,
  transacted int  NOT NULL DEFAULT 0,
  details varbinary,
  PRIMARY KEY(jobid));

CREATE INDEX IDX_ODE_JOB_TS ON ode_job(ts);
CREATE INDEX IDX_ODE_JOB_NODEID ON ode_job(nodeid);


create table BPEL_ACTIVITY_RECOVERY (ID bigint generated by default as identity (start with 1), PIID bigint, AID bigint, CHANNEL varchar(255), REASON varchar(255), DATE_TIME timestamp, LDATA_ID bigint, ACTIONS varchar(255), RETRIES integer, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_CORRELATION_PROP (ID bigint generated by default as identity (start with 1), NAME varchar(255), NAMESPACE varchar(255), VALUE varchar(255), CORR_SET_ID bigint, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_CORRELATION_SET (ID bigint generated by default as identity (start with 1), VALUE varchar(255), CORR_SET_NAME varchar(255), SCOPE_ID bigint, PIID bigint, PROCESS_ID bigint, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_CORRELATOR (ID bigint generated by default as identity (start with 1), CID varchar(255), PROCESS_ID bigint, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_CORRELATOR_MESSAGE_CKEY (ID bigint generated by default as identity (start with 1), CKEY varchar(255), CORRELATOR_MESSAGE_ID bigint, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_EVENT (ID bigint generated by default as identity (start with 1), IID bigint, PID bigint, TSTAMP timestamp, TYPE varchar(255), DETAIL longvarchar, LDATA_ID bigint, SID bigint, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_FAULT (ID bigint generated by default as identity (start with 1), FAULTNAME varchar(255), LDATA_ID bigint, EXPLANATION varchar(4000), LINE_NUM integer, AID integer, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_INSTANCE (ID bigint generated by default as identity (start with 1), INSTANTIATING_CORRELATOR bigint, FAULT bigint, JACOB_STATE bigint, PREVIOUS_STATE smallint, PROCESS_ID bigint, STATE smallint, LAST_ACTIVE_DT timestamp, SEQUENCE bigint, FAILURE_COUNT integer, FAILURE_DT timestamp, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_MESSAGE (ID bigint generated by default as identity (start with 1), MEX bigint, TYPE varchar(255), DATA bigint, HEADER bigint, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_MESSAGE_EXCHANGE (ID bigint generated by default as identity (start with 1), PORT_TYPE varchar(255), CHANNEL_NAME varchar(255), CLIENTKEY varchar(255), LDATA_EPR_ID bigint, LDATA_CEPR_ID bigint, REQUEST bigint, RESPONSE bigint, INSERT_DT timestamp, OPERATION varchar(255), STATE varchar(255), PROCESS bigint, PIID bigint, DIR char(1), PLINK_MODELID integer, PATTERN varchar(255), CORR_STATUS varchar(255), FAULT_TYPE varchar(255), FAULT_EXPL varchar(255), CALLEE varchar(255), PARTNERLINK bigint, PIPED_ID varchar(255), SUBSCRIBER_COUNT integer, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_MEX_PROPS (MEX bigint not null, VALUE varchar(8000), NAME varchar(255) not null, primary key (MEX, NAME));
create table BPEL_PLINK_VAL (ID bigint generated by default as identity (start with 1), PARTNER_LINK varchar(100) not null, PARTNERROLE varchar(100), MYROLE_EPR bigint, PARTNERROLE_EPR bigint, PROCESS bigint, SCOPE bigint, SVCNAME varchar(255), MYROLE varchar(100), MODELID integer, MYSESSIONID varchar(255), PARTNERSESSIONID varchar(255), INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_PROCESS (ID bigint generated by default as identity (start with 1), PROCID varchar(255) not null, deployer varchar(255), deploydate timestamp, type_name varchar(255), type_ns varchar(255), version bigint, ACTIVE_ bit, guid varchar(255), INSERT_TIME timestamp, MLOCK integer not null, primary key (ID), unique (PROCID));
create table BPEL_SCOPE (ID bigint generated by default as identity (start with 1), PIID bigint, PARENT_SCOPE_ID bigint, STATE varchar(255) not null, NAME varchar(255) not null, MODELID integer, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_SELECTORS (ID bigint generated by default as identity (start with 1), PIID bigint not null, SELGRPID varchar(255) not null, IDX integer not null, CORRELATION_KEY varchar(255) not null, PROC_TYPE varchar(255) not null, ROUTE_POLICY varchar(255), CORRELATOR bigint not null, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID), unique (CORRELATION_KEY, CORRELATOR));
create table BPEL_UNMATCHED (ID bigint generated by default as identity (start with 1), MEX bigint, CORRELATION_KEY varchar(255), CORRELATOR bigint not null, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table BPEL_XML_DATA (ID bigint generated by default as identity (start with 1), LDATA_ID bigint, NAME varchar(255) not null, SCOPE_ID bigint, PIID bigint, IS_SIMPLE_TYPE bit, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table LARGE_DATA (ID bigint generated by default as identity (start with 1), BIN_DATA varbinary, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create table VAR_PROPERTY (ID bigint generated by default as identity (start with 1), XML_DATA_ID bigint, PROP_VALUE varchar(255), PROP_NAME varchar(255) not null, INSERT_TIME timestamp, MLOCK integer not null, primary key (ID));
create index IDX_CORRELATOR_CID on BPEL_CORRELATOR (CID);
create index IDX_BPEL_CORRELATOR_MESSAGE_CKEY on BPEL_CORRELATOR_MESSAGE_CKEY (CKEY);
create index IDX_SELECTOR_CORRELATOR on BPEL_SELECTORS (CORRELATOR);
create index IDX_SELECTOR_CKEY on BPEL_SELECTORS (CORRELATION_KEY);
create index IDX_SELECTOR_SELGRPID on BPEL_SELECTORS (SELGRPID);
create index IDX_UNMATCHED_CKEY on BPEL_UNMATCHED (CORRELATION_KEY);
create index IDX_UNMATCHED_CORRELATOR on BPEL_UNMATCHED (CORRELATOR);
