/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.deployer.jboss;

import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;

import java.util.ArrayList;
import java.util.List;

/**
 * Creates an in-memory representation of web meta data.
 * Based on http://anonsvn.jboss.org/repos/jbossas/tags/JBoss_5_1_0_GA/webservices/src/main/org/jboss/wsf/container/jboss50/transport/WebAppGeneratorDeploymentAspect.java
 * 
 * @author Heiko.Braun <heiko.braun@jboss.com>
 */
public class WebMetaDataFactory
{
  private String endpointId;
  private String servletClassName = null;
  private String webContext = null;
  private String urlPattern = null;

  public WebMetaDataFactory(String endpointId, String webContext, String urlPattern, String servletClassName)
  {
    this.endpointId = endpointId;
    this.servletClassName = servletClassName;
    this.webContext = webContext;
    this.urlPattern = urlPattern;
  }

  public JBossWebMetaData createWebMetaData(ClassLoader loader)
  {
    JBossWebMetaData jbwmd = new JBossWebMetaData();
    createWebAppDescriptor(jbwmd);
    createJBossWebAppDescriptor(jbwmd);      
    return jbwmd;
  }

  private void createWebAppDescriptor(JBossWebMetaData jbwmd)
  {
    /*
    <servlet>
    <servlet-name>
    <servlet-class>
    </servlet>
    */
    JBossServletsMetaData servlets = jbwmd.getServlets();
    JBossServletMetaData servlet = new JBossServletMetaData();
    servlet.setServletName("Endpoint-"+endpointId);
    servlet.setServletClass(servletClassName);
    servlets.add(servlet);


    /*
    <servlet-mapping>
    <servlet-name>
    <url-pattern>
    </servlet-mapping>
    */
    List<ServletMappingMetaData> servletMappings = jbwmd.getServletMappings();
    if (servletMappings == null)
    {
      servletMappings = new ArrayList<ServletMappingMetaData>();
      jbwmd.setServletMappings(servletMappings);
    }
    ServletMappingMetaData servletMapping = new ServletMappingMetaData();
    servletMapping.setServletName("Endpoint-"+endpointId);
    ArrayList<String> urlPatterns = new ArrayList<String>();
    urlPatterns.add(urlPattern);
    servletMapping.setUrlPatterns(urlPatterns);
    servletMappings.add(servletMapping);

  }

  private void createJBossWebAppDescriptor(JBossWebMetaData jbwmd)
  {
    /* Create a jboss-web
    <jboss-web>
    <security-domain>java:/jaas/cts</security-domain>
    <context-root>/ws/ejbN/</context-root>
    <virtual-host>some.domain.com</virtual-host>
    </jboss-web>
    */

    jbwmd.setContextRoot(webContext);
  }
}
