/*
 * Copyright 2010 Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.jboss.soa.dsp.server.jboss;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import java.util.Iterator;

/**
 * Locate the single instance of the MBeanServer
 *
 * @author Thomas.Diesler@jboss.org
 * @since 30-Jul-2007
 */
public class MBeanServerLocator
{
  private MBeanServer mbeanServer;

  public MBeanServer getMbeanServer()
  {
    // In jboss-4.2 the MBeanServer cannot be injected
    if (mbeanServer == null)
    {
      for (Iterator i = MBeanServerFactory.findMBeanServer(null).iterator(); i.hasNext();)
      {
        mbeanServer = (MBeanServer)i.next();
        break;
      }
    }
    return mbeanServer;
  }

  public void setMbeanServer(MBeanServer mbeanServer)
  {
    this.mbeanServer = mbeanServer;
  }
}
