/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.qa.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class WhitespaceCheck
extends Check {
    private boolean checkMultipleSpaces = false;

    public void setCheckMultipleSpaces(boolean checkMultipleSpaces) {
        this.checkMultipleSpaces = checkMultipleSpaces;
    }

    public int[] getDefaultTokens() {
        return new int[0];
    }

    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            this.checkTrailingWhitespaces(lines[i], i + 1);
        }
        if (this.checkMultipleSpaces) {
            this.checkMultipleConsecutiveSpaces(lines);
        }
    }

    private void checkMultipleConsecutiveSpaces(String[] lines) {
        boolean inString = false;
        boolean inBlockComment = false;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int prev = 120;
            int spaces = 0;
            for (int j = 0; j < line.length(); ++j) {
                char ch = lines[i].charAt(j);
                if (ch == '*') {
                    if (prev == 47) {
                        inBlockComment = true;
                        prev = 120;
                        spaces = 0;
                        continue;
                    }
                    prev = 42;
                    spaces = 0;
                    continue;
                }
                if (ch == '/') {
                    if (inBlockComment && prev == 42) {
                        inBlockComment = false;
                        prev = 120;
                        spaces = 0;
                        continue;
                    }
                    prev = ch;
                    spaces = 0;
                    continue;
                }
                if (inBlockComment) continue;
                if (ch == '\"') {
                    if (inString) {
                        if (prev == 92) continue;
                        inString = false;
                        continue;
                    }
                    inString = true;
                    if (spaces > 1) {
                        this.log(i + 1, j, "consecutive.spaces", new Object[]{spaces});
                    }
                    prev = 120;
                    spaces = 0;
                    continue;
                }
                if (ch == '\\') {
                    if (prev == 92) {
                        prev = 120;
                        spaces = 0;
                        continue;
                    }
                    prev = 92;
                    spaces = 0;
                    continue;
                }
                if (!inString && ch == ' ') {
                    prev = ch;
                    ++spaces;
                    continue;
                }
                if (spaces > 1) {
                    this.log(i + 1, j, "consecutive.spaces", new Object[]{spaces});
                }
                prev = 120;
                spaces = 0;
            }
        }
    }

    private void checkTrailingWhitespaces(String line, int nr) {
        if (line.length() > 0 && (line.endsWith(" ") || line.endsWith("\t"))) {
            this.log(nr, line.length(), "trailing.whitespaces", new Object[0]);
        }
    }
}

