/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.logging;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.solder.logging.Log;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.logging.MessageLogger;
import org.jboss.solder.logging.internal.BasicLogger;
import org.jboss.solder.messages.Message;
import org.jboss.solder.messages.MessageBundleInvocationHandler;

public class MessageLoggerInvocationHandler
extends MessageBundleInvocationHandler {
    private final Logger logger;

    public MessageLoggerInvocationHandler(Class<?> type, String category) {
        this(type.getAnnotation(MessageLogger.class), category);
    }

    private MessageLoggerInvocationHandler(MessageLogger messageLogger, String category) {
        super(messageLogger.projectCode());
        this.logger = Logger.getLogger(category);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Message message = method.getAnnotation(Message.class);
        if (message == null) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Log logMessage = method.getAnnotation(Log.class);
        if (logMessage != null) {
            try {
                if (method.getDeclaringClass().equals(BasicLogger.class)) {
                    return method.invoke((Object)this.logger, args);
                }
                Logger.Level level = logMessage.level();
                if (this.logger.isEnabled(level)) {
                    String formatString = this.getFormatString(message);
                    if (formatString == null) {
                        return null;
                    }
                    ArrayList<Object> newArgs = new ArrayList<Object>();
                    Throwable cause = MessageLoggerInvocationHandler.extractCause(parameterAnnotations, args, newArgs);
                    Message.Format format = message.format();
                    switch (format) {
                        case PRINTF: {
                            this.logger.logf(level, cause, formatString, newArgs.toArray());
                            return null;
                        }
                        case MESSAGE_FORMAT: {
                            this.logger.logv(level, cause, formatString, newArgs.toArray());
                            return null;
                        }
                    }
                    return null;
                }
            }
            catch (Throwable ignored) {}
        } else {
            return super.invoke(proxy, method, args);
        }
        return null;
    }
}

