/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.unwraps;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.solder.bean.ImmutableInjectionPoint;

public class UnwrapsInvocationHandler
implements MethodHandler {
    private final BeanManager manager;
    private final AnnotatedMethod<?> annotatedMethod;
    private final Method method;
    private final Bean<?> bean;
    private final InjectionPoint[] injectionPoints;
    private final Bean<?> mainClassBean;
    private final InjectionPoint injectionPoint;

    public UnwrapsInvocationHandler(BeanManager manager, AnnotatedMethod<?> method, Bean<?> bean, InjectionPoint injectionPoint, Set<Annotation> declaringBeanQualifiers) {
        HashSet<Annotation> mainClassQualifiers;
        this.manager = manager;
        this.method = method.getJavaMember();
        this.annotatedMethod = method;
        this.bean = bean;
        this.injectionPoints = new InjectionPoint[this.method.getTypeParameters().length];
        for (int i = 0; i < this.injectionPoints.length; ++i) {
            this.injectionPoints[i] = new ImmutableInjectionPoint((AnnotatedParameter)method.getParameters().get(i), manager, bean, false, false);
        }
        Type mainType = method.getDeclaringType().getBaseType();
        Set beans = manager.getBeans(mainType, (mainClassQualifiers = new HashSet<Annotation>(declaringBeanQualifiers)).toArray(new Annotation[0]));
        if (beans.isEmpty()) {
            throw new UnsatisfiedResolutionException("Could not find declaring bean for @Unwrap method " + method.getDeclaringType().getJavaClass() + "." + this.method.getName());
        }
        if (beans.size() > 1) {
            throw new AmbiguousResolutionException("Could not find declaring bean for @Unwrap method " + method.getDeclaringType().getJavaClass() + "." + this.method.getName());
        }
        this.mainClassBean = (Bean)beans.iterator().next();
        this.injectionPoint = injectionPoint;
    }

    public Object invoke(Object proxy, Method thisMethod, Method m, Object[] args) throws Throwable {
        CreationalContext ctx = this.manager.createCreationalContext(this.bean);
        Object[] params = new Object[this.method.getParameterTypes().length];
        for (int i = 0; i < this.method.getParameterTypes().length; ++i) {
            params[i] = InjectionPoint.class.isAssignableFrom(this.method.getParameterTypes()[i]) ? this.injectionPoint : this.manager.getInjectableReference(this.injectionPoints[i], ctx);
        }
        Object base = this.manager.getReference(this.mainClassBean, (Type)this.annotatedMethod.getDeclaringType().getJavaClass(), ctx);
        Object result = this.method.invoke(base, params);
        Object ret = thisMethod.invoke(result, args);
        ctx.release();
        return ret;
    }
}

